<?php
/**
 * Extend customizer section.
 *
 * @package Matcha_Extra
 * @since 1.0.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

function matcha_extra_frontpage_sections_settings($wp_customize) {

    /* Frontpage panel */
    $wp_customize->add_panel('pawfect_frontpage_settings', array(
        'priority' => 10,
        'capability' => 'edit_theme_options',
        'title' => __('Frontpage Sections', 'matcha-extra'),
    ));

    // Add all the frontpage sections back when plugin is active
    $wp_customize->add_section('pawfect_main_theme_slider', array(
        'title' => esc_html__('Hero Slider', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 10,
    ));

    $wp_customize->add_section('pawfect_theme_press_mentions', array(
        'title' => esc_html__('Press Mentions', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 20,
    ));

    $wp_customize->add_section('pawfect_theme_feature_highlight', array(
        'title' => esc_html__('Feature Highlight', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 30,
    ));

    $wp_customize->add_section('pawfect_theme_portfolio', array(
        'title' => esc_html__('Shop by Category / Portfolio', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 40,
    ));

    $wp_customize->add_section('pawfect_theme_service', array(
        'title' => esc_html__('Service / why Choose Us Settings', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 45,
    ));

    $wp_customize->add_section('pawfect_theme_testimonial', array(
        'title' => esc_html__('Testimonial Settings', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 50,
    ));

    $wp_customize->add_section('pawfect_mission_section', array(
        'title' => esc_html__('Mission Section', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 60,
    ));

    $wp_customize->add_section('pawfect_theme_blog', array(
        'title' => esc_html__('Blog Settings', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 70,
    ));

    // WooCommerce section (conditional)
    if (class_exists('WooCommerce')) {
        $wp_customize->add_section('pawfect_theme_woocommerce', array(
            'title' => esc_html__('WooCommerce Settings', 'matcha-extra'),
            'panel' => 'pawfect_frontpage_settings',
            'priority' => 75,
        ));
    }

    $wp_customize->add_section('pawfect_crafted_section', array(
        'title' => esc_html__('Crafted With Care', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 75,
    ));

    $wp_customize->add_section('pawfect_pet_shop_section', array(
        'title' => esc_html__('Shop By Pet', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 80,
    ));

    $wp_customize->add_section('pawfect_instagram_gallery_section', array(
        'title' => esc_html__('Instagram Gallery', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 90,
    ));

    $wp_customize->add_section('pawfect_promo_timer_section', array(
        'title' => esc_html__('Promo Timer', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 100,
    ));

    $wp_customize->add_section('pawfect_promo_banner_section', array(
        'title' => esc_html__('Promo Banner', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 105,
    ));

    $wp_customize->add_section('frontpage_layout', array(
        'title' => esc_html__('Front Page layout', 'matcha-extra'),
        'panel' => 'pawfect_frontpage_settings',
        'priority' => 106,
    ));

    // Plugin only adds the frontpage sections back to theme
    // It doesn't add extra customizer options beyond what theme originally had
    // The theme's existing customizer options will work with these sections
}
add_action('customize_register', 'matcha_extra_frontpage_sections_settings', 15);
