<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Default customizer values for Pawfect Companion
 *
 * @package matcha-extra
 */

$activate_theme_data = wp_get_theme(); // getting current theme data.
$activate_theme = $activate_theme_data->name;

if ('Pawfect' == $activate_theme || 'pawfect' == $activate_theme_data->get('Template')) {
    
    // Set default customizer values on theme activation
    if (!function_exists('matcha_extra_set_default_customizer_values')) {
        function matcha_extra_set_default_customizer_values() {
            
            // Hero Slider Default Content
            $default_slider_content = json_encode([
                [
                    'title' => 'Welcome to Pawfect',
                    'subtitle' => 'Everything Your Pet Needs',
                    'text' => 'Discover premium pet products and services designed to keep your furry friends happy and healthy.',
                    'button_text' => 'Shop Now',
                    'link' => '#',
                    'image_url' => MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/img/slider/slide1.jpg',
                    'open_new_tab' => 'no'
                ],
                [
                    'title' => 'Premium Pet Care',
                    'subtitle' => 'Quality You Can Trust',
                    'text' => 'From nutritious food to comfortable accessories, we provide everything your pet deserves.',
                    'button_text' => 'Learn More',
                    'link' => '#',
                    'image_url' => MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/img/slider/slide2.jpg',
                    'open_new_tab' => 'no'
                ]
            ]);

            // Set default theme mods if they don't exist
            $defaults = array(
                // Hero Slider
                'pawfect_hero_slider_disabled' => true,
                'pawfect_hero_slider_content' => $default_slider_content,
                'pawfect_hero_slider_animation_speed' => 4000,
                'pawfect_hero_slider_autoplay_disable' => true,
                
                // Press Mentions
                'pawfect_press_mentions_enabled' => true,
                
                // Feature Highlight
                'pawfect_feature_highlight_disabled' => false,
                'pawfect_feature_highlight_title' => 'Why Choose Pawfect?',
                'pawfect_feature_highlight_subtitle' => 'Premium Quality Pet Products',
                
                // Why Choose
                'pawfect_why_choose_disabled' => false,
                'pawfect_why_choose_title' => 'Why Pet Parents Choose Us',
                'pawfect_why_choose_subtitle' => 'Trusted by thousands of pet families',
                
                // Portfolio
                'pawfect_portfolio_enabled' => true,
                'pawfect_portfolio_title' => 'Our Happy Customers',
                'pawfect_portfolio_subtitle' => 'See what makes tails wag',
                
                // Featured Collection
                'pawfect_featured_collection_enabled' => true,
                'pawfect_featured_collection_title' => 'Featured Products',
                'pawfect_featured_collection_subtitle' => 'Handpicked favorites for your pet',
                
                // Testimonial
                'pawfect_testimonial_disabled' => false,
                'pawfect_testimonial_title' => 'What Pet Parents Say',
                'pawfect_testimonial_subtitle' => 'Real reviews from real customers',
                
                // Mission
                'pawfect_mission_enabled' => true,
                'pawfect_mission_title' => 'Our Mission',
                'pawfect_mission_subtitle' => 'Dedicated to pet happiness',
                
                // Pet Shop
                'pawfect_pet_shop_enabled' => true,
                'pawfect_pet_shop_title' => 'Shop by Pet',
                'pawfect_pet_shop_subtitle' => 'Find products for your specific pet',
                
                // Promo Timer
                'pawfect_promo_timer_enabled' => true,
                'pawfect_promo_timer_title' => 'Limited Time Offer',
                'pawfect_promo_timer_subtitle' => 'Don\'t miss out on great deals',
                
                // Crafted
                'pawfect_crafted_enabled' => true,
                'pawfect_crafted_title' => 'Carefully Crafted',
                'pawfect_crafted_subtitle' => 'Quality in every detail',
                
                // Blog
                'pawfect_blog_disabled' => false,
                'pawfect_blog_title' => 'Pet Care Tips & News',
                'pawfect_blog_subtitle' => 'Expert advice for pet parents',
                
                // Promo Banner
                'pawfect_promo_banner_enabled' => true,
                'pawfect_promo_banner_title' => 'Special Offer',
                'pawfect_promo_banner_subtitle' => 'Save on premium pet products',
                
                // Instagram
                'pawfect_instagram_enabled' => true,
                'pawfect_instagram_title' => 'Follow Us',
                'pawfect_instagram_subtitle' => '@pawfect_pets',
                
                // CTA
                'pawfect_cta_enabled' => true,
                'pawfect_cta_title' => 'Ready to Give Your Pet the Best?',
                'pawfect_cta_desc' => 'Join thousands of happy pet parents who trust us with their furry family members.',
                'pawfect_cta_button_text' => 'Shop Now',
                'pawfect_cta_button_url' => '#',
                
                // WooCommerce
                'pawfect_woocommerce_enabled' => true,
                'pawfect_woocommerce_title' => 'Featured Products',
                'pawfect_woocommerce_subtitle' => 'Best sellers for your pet',
            );

            foreach ($defaults as $key => $value) {
                if (get_theme_mod($key) === false) {
                    set_theme_mod($key, $value);
                }
            }
        }
        
        // Hook into after_switch_theme to set defaults
        add_action('after_switch_theme', 'matcha_extra_set_default_customizer_values');

        // Also set defaults on plugin activation
        add_action('matcha_extra_activated', 'matcha_extra_set_default_customizer_values');
    }
}
