(function($) {
    'use strict';

    $(document).ready(function() {
        
        // Handle repeater controls
        $('.repeater-wrapper').each(function() {
            var $wrapper = $(this);
            var $items = $wrapper.find('.repeater-items');
            var $addButton = $wrapper.find('.repeater-add-item');
            var $hiddenInput = $wrapper.find('input[type="hidden"]');
            var fields = $addButton.data('fields') || {};

            // Toggle item content
            $wrapper.on('click', '.repeater-item-toggle', function(e) {
                e.preventDefault();
                var $item = $(this).closest('.repeater-item');
                $item.toggleClass('active');
                $(this).text($item.hasClass('active') ? 'Collapse' : 'Expand');
            });

            // Remove item
            $wrapper.on('click', '.repeater-item-remove', function(e) {
                e.preventDefault();
                if (confirm('Are you sure you want to remove this item?')) {
                    $(this).closest('.repeater-item').remove();
                    updateRepeaterValue($wrapper);
                }
            });

            // Update values when fields change
            $wrapper.on('input change', '.repeater-field input, .repeater-field textarea', function() {
                updateRepeaterValue($wrapper);
            });

            // Handle image upload
            $wrapper.on('click', '.upload-button', function(e) {
                e.preventDefault();
                var $button = $(this);
                var $field = $button.closest('.upload-field');
                var $input = $field.find('input[type="hidden"]');
                var $preview = $field.find('.image-preview');
                var $removeButton = $field.find('.remove-image');

                var mediaUploader = wp.media({
                    title: 'Choose Image',
                    button: {
                        text: 'Choose Image'
                    },
                    multiple: false
                });

                mediaUploader.on('select', function() {
                    var attachment = mediaUploader.state().get('selection').first().toJSON();
                    $input.val(attachment.url).trigger('change');
                    $preview.html('<img src="' + attachment.url + '" style="max-width: 100px; height: auto;" />');
                    $removeButton.show();
                });

                mediaUploader.open();
            });

            // Handle image removal
            $wrapper.on('click', '.remove-image', function(e) {
                e.preventDefault();
                var $button = $(this);
                var $field = $button.closest('.upload-field');
                var $input = $field.find('input[type="hidden"]');
                var $preview = $field.find('.image-preview');

                $input.val('').trigger('change');
                $preview.empty();
                $button.hide();
            });

            // Add new item
            $addButton.on('click', function(e) {
                e.preventDefault();
                addRepeaterItem($wrapper);
            });

            // Initialize existing items
            $wrapper.find('.repeater-item').first().addClass('active').find('.repeater-item-toggle').text('Collapse');
        });

        function addRepeaterItem($wrapper) {
            var $items = $wrapper.find('.repeater-items');
            var itemCount = $items.find('.repeater-item').length;
            var itemTitle = 'Item ' + (itemCount + 1);

            var itemHtml = '<div class="repeater-item active">' +
                '<div class="repeater-item-header">' +
                    '<span class="repeater-item-title">' + itemTitle + '</span>' +
                    '<button type="button" class="repeater-item-toggle">Collapse</button>' +
                    '<button type="button" class="repeater-item-remove">Remove</button>' +
                '</div>' +
                '<div class="repeater-item-content">' +
                    '<div class="repeater-field">' +
                        '<label>Title</label>' +
                        '<input type="text" data-field="title" value="" />' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Subtitle</label>' +
                        '<input type="text" data-field="subtitle" value="" />' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Description</label>' +
                        '<textarea data-field="text"></textarea>' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Button Text</label>' +
                        '<input type="text" data-field="button_text" value="" />' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Button Link</label>' +
                        '<input type="url" data-field="link" value="" />' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Background Image</label>' +
                        '<div class="upload-field">' +
                            '<input type="hidden" data-field="image_url" value="" />' +
                            '<button type="button" class="upload-button">Choose Image</button>' +
                            '<button type="button" class="remove-image" style="display:none;">Remove</button>' +
                            '<div class="image-preview"></div>' +
                        '</div>' +
                    '</div>' +
                    '<div class="repeater-field">' +
                        '<label>Open in New Tab (yes/no)</label>' +
                        '<input type="text" data-field="open_new_tab" value="no" />' +
                    '</div>' +
                '</div>' +
            '</div>';

            $items.append(itemHtml);
            updateRepeaterValue($wrapper);
        }

        function updateRepeaterValue($wrapper) {
            var $hiddenInput = $wrapper.find('input[type="hidden"]');
            var items = [];

            $wrapper.find('.repeater-item').each(function() {
                var $item = $(this);
                var itemData = {};

                $item.find('[data-field]').each(function() {
                    var $field = $(this);
                    var fieldName = $field.data('field');
                    var fieldValue = $field.val();
                    itemData[fieldName] = fieldValue;
                });

                items.push(itemData);
            });

            $hiddenInput.val(JSON.stringify(items)).trigger('change');
        }
    });

})(jQuery);
