<?php
/**
 * Fired during plugin activation
 *
 * @package Matcha_Extra
 * @since 1.0.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

class Matcha_Extra_Plugin_Activator {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function activate() {
        // Set default theme mods for Pawfect theme
        self::set_default_theme_mods();

        // Set activation notice
        set_transient('matcha_extra_activated_notice', true, 30);

        // Flush rewrite rules
        flush_rewrite_rules();
    }

    /**
     * Set default theme modifications
     */
    private static function set_default_theme_mods() {
        // Set default front page sections
        $default_sections = 'hero_slider,press_mentions,feature_highlight,why_choose,portfolio,featured_collection,testimonial,mission,pet_shop,promo_timer,crafted,blog,promo_banner,instagram,cta,woocommerce';
        
        if (!get_theme_mod('front_page_data')) {
            set_theme_mod('front_page_data', $default_sections);
        }

        // Set default hero slider content
        if (!get_theme_mod('pawfect_hero_slider_content')) {
            $default_slider = json_encode([
                [
                    'title' => 'Welcome to Pawfect',
                    'subtitle' => 'Everything Your Pet Needs',
                    'text' => 'Discover premium pet products and services designed to keep your furry friends happy and healthy.',
                    'button_text' => 'Shop Now',
                    'link' => '#',
                    'image_url' => MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/img/slider/slide1.jpg',
                    'open_new_tab' => 'no'
                ],
                [
                    'title' => 'Premium Pet Care',
                    'subtitle' => 'Quality You Can Trust',
                    'text' => 'From nutritious food to comfortable accessories, we provide everything your pet deserves.',
                    'button_text' => 'Learn More',
                    'link' => '#',
                    'image_url' => MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/img/slider/slide2.jpg',
                    'open_new_tab' => 'no'
                ]
            ]);
            set_theme_mod('pawfect_hero_slider_content', $default_slider);
        }

        // Set other default values
        $defaults = [
            'pawfect_hero_slider_disabled' => true,
            'pawfect_press_mentions_enabled' => true,
            'pawfect_feature_highlight_disabled' => false,
            'pawfect_why_choose_disabled' => false,
            'pawfect_portfolio_enabled' => true,
            'pawfect_featured_collection_enabled' => true,
            'pawfect_testimonial_disabled' => false,
            'pawfect_mission_enabled' => true,
            'pawfect_pet_shop_enabled' => true,
            'pawfect_promo_timer_enabled' => true,
            'pawfect_crafted_enabled' => true,
            'pawfect_blog_disabled' => false,
            'pawfect_promo_banner_enabled' => true,
            'pawfect_instagram_enabled' => true,
            'pawfect_cta_enabled' => true,
            'pawfect_woocommerce_enabled' => true,
        ];

        foreach ($defaults as $key => $value) {
            if (get_theme_mod($key) === false) {
                set_theme_mod($key, $value);
            }
        }
    }
}
