<?php

namespace MasterStudy\Lms\Http\Controllers\Course;

use MasterStudy\Lms\Http\WpResponseFactory;
use MasterStudy\Lms\Repositories\CourseRepository;
use MasterStudy\Lms\Validation\Validator;
use WP_REST_Request;
use WP_REST_Response;

class UpdateCertificateSettingsController {
	private CourseRepository $course_repository;

	public function __construct() {
		$this->course_repository = new CourseRepository();
	}

	public function __invoke( int $course_id, WP_REST_Request $request ): WP_REST_Response {
		$course = $this->course_repository->find_post( $course_id );

		if ( null === $course ) {
			return WpResponseFactory::not_found();
		}

		$validator = new Validator(
			$request->get_json_params(),
			array(
				'certificate_id' => 'nullable|string',
			)
		);

		if ( $validator->fails() ) {
			return WpResponseFactory::validation_failed( $validator->get_errors_array() );
		}

		$data = $validator->get_validated();

		if ( 'none' !== $data['certificate_id'] ) {
			$data['certificate_id'] = intval( $data['certificate_id'] );
		}

		$this->course_repository->update_certificate( $course_id, $data['certificate_id'] );

		return WpResponseFactory::ok();
	}
}
