<?php
/*
* Master Addons : Welcome Screen by Jewel Theme
*/

// Check if PRO version is active and set constants accordingly
if (\MasterAddons\Inc\Helper\Master_Addons_Helper::jltma_premium()) {
	$jltma_prefix = JLTMA_PRO;
	$jltma_ver = JLTMA_PRO_VER;
	$jltma_path = JLTMA_PRO_PATH;
} else {
	$jltma_prefix = JLTMA;
	$jltma_ver = JLTMA_VER;
	$jltma_path = JLTMA_PATH;
}
// JLTMA_IMAGE_DIR stays the same for both versions
$jltma_image_dir = JLTMA_IMAGE_DIR;

$jltma_white_label_setting 	= jltma_get_options('jltma_white_label_settings') ?? [];
if ( empty($jltma_white_label_setting) ) {
	$jltma_white_label_setting = apply_filters('jltma_white_label_default_options', array());
}

$jltma_hide_welcome 		     = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_welcome'] ?? false);
$jltma_hide_addons 			     = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_addons'] ?? false);
$jltma_hide_extensions 		  = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_extensions'] ?? false);
$jltma_hide_icons_library 	= jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_icons_library'] ?? false);
$jltma_hide_api 			        = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_api'] ?? false);
$jltma_hide_white_label 	  = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_white_label'] ?? false);
$jltma_hide_version 		     = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_version'] ?? false);
// $jltma_hide_changelogs 		  = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_changelogs'] ?? false);
$jltma_hide_system_info 	  = jltma_check_options($jltma_white_label_setting['jltma_wl_plugin_tab_system_info'] ?? false);
?>
<div class="jltma-master-addons-admin">
	<div class="jltma-master-addons-wrap">

		<header class="jltma-master-addons-header is-flex">
			<a class="jltma-master-addons-panel-logo" href="https://master-addons.com/?utm_source=dashboard&utm_medium=settings_header&utm_id=admin_dashboard" target="_blank">
				<?php
					$jltma_logo_image = apply_filters('master_addons/white_label/menu_logo', $jltma_image_dir . 'logo.svg');
					?>
				<img src="<?php echo esc_url($jltma_logo_image ); ?>" />
			</a>

			<h1 class="jltma-master-addons-title">
				<?php if (!empty($jltma_white_label_setting['jltma_wl_plugin_menu_label'])) {
					printf(__('%s <small>v %s</small>'), $jltma_white_label_setting['jltma_wl_plugin_menu_label'], $jltma_ver);
				} else {
					printf(__('%s <small>v %s</small>'), $jltma_prefix, $jltma_ver);
				}
				?>
			</h1>

			<div class="jltma-master-addons-header-text"></div>
		</header>

		<?php require_once $jltma_path . 'inc/admin/welcome/navigation.php'; ?>

		<div class="jltma-master-addons-tab-contents">
			<?php
			if (isset($jltma_hide_welcome) && !$jltma_hide_welcome) {
				require $jltma_path . 'inc/admin/welcome/supports.php';
			}

			if (isset($jltma_hide_addons) && !$jltma_hide_addons) {
				require $jltma_path . 'inc/admin/welcome/addons.php';
			}

			if (isset($jltma_hide_extensions) && !$jltma_hide_extensions) {
				require $jltma_path . 'inc/admin/welcome/extensions.php';
			}

			if (isset($jltma_hide_icons_library) && !$jltma_hide_icons_library) {
				require $jltma_path . 'inc/admin/welcome/icons-library.php';
			}

			if (isset($jltma_hide_api) && !$jltma_hide_api) {
				require $jltma_path . 'inc/admin/welcome/api-keys.php';
			}

			if (isset($jltma_hide_version) && !$jltma_hide_version) {
				require $jltma_path . 'inc/admin/welcome/version-control.php';
			}

			// if (isset($jltma_hide_changelogs) && !$jltma_hide_changelogs) {
			// 	require $jltma_path . 'inc/admin/welcome/changelogs.php';
			// }

			if (isset($jltma_hide_white_label) && !$jltma_hide_white_label) {
				require $jltma_path . 'inc/admin/welcome/white-label.php';
			}

			if (isset($jltma_hide_system_info) && !$jltma_hide_system_info) {
				require $jltma_path . 'inc/admin/welcome/system-info.php';
			}
			?>
		</div>

	</div>
</div>
