<?php
/**
 * Trial Booking Form Template
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/public
 * @since      1.0.61
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="kcm-trial-booking-container">
	<div id="kcm-booking-message" class="kcm-message" style="display: none;"></div>

	<form id="kcm-trial-booking-form" class="kcm-trial-booking-form">
		<div class="kcm-form-section">
			<h3><?php esc_html_e( 'Your Information', 'martial-arts-club-manager' ); ?></h3>

			<div class="kcm-form-group">
				<label for="full_name" id="full_name_label">
					<?php esc_html_e( 'Full Name', 'martial-arts-club-manager' ); ?>
					<span class="required">*</span>
				</label>
				<input
					type="text"
					id="full_name"
					name="full_name"
					required
					class="kcm-form-control"
				/>
				<p class="kcm-field-description" style="font-size: 12px; color: #6B7280; margin-top: 5px; display: none;" id="full_name_hint">
					<?php esc_html_e( 'Enter the child\'s name', 'martial-arts-club-manager' ); ?>
				</p>
			</div>

			<div class="kcm-form-group">
				<label class="kcm-checkbox-label">
					<input
						type="checkbox"
						id="is_for_child"
						name="is_for_child"
						value="1"
					/>
					<?php esc_html_e( 'This booking is for my child', 'martial-arts-club-manager' ); ?>
				</label>
			</div>

			<div class="kcm-form-group" id="parent_name_group" style="display: none;">
				<label for="parent_name">
					<?php esc_html_e( 'Parent Name', 'martial-arts-club-manager' ); ?>
					<span class="required">*</span>
				</label>
				<input
					type="text"
					id="parent_name"
					name="parent_name"
					class="kcm-form-control"
				/>
			</div>

			<div class="kcm-form-group">
				<label for="mobile">
					<?php esc_html_e( 'Mobile Number', 'martial-arts-club-manager' ); ?>
				</label>
				<input
					type="tel"
					id="mobile"
					name="mobile"
					pattern="[0-9\s\-\+\(\)]+"
					class="kcm-form-control"
					placeholder="<?php esc_attr_e( 'Numbers only', 'martial-arts-club-manager' ); ?>"
				/>
			</div>

			<div class="kcm-form-group">
				<label for="email">
					<?php esc_html_e( 'Email', 'martial-arts-club-manager' ); ?>
					<span class="required">*</span>
				</label>
				<input
					type="email"
					id="email"
					name="email"
					required
					class="kcm-form-control"
				/>
			</div>
		</div>

		<?php
		$macm_premium_files_exist = file_exists( MACM_PLUGIN_DIR . 'includes/classes/class-macm-location.php' );
		$macm_can_use_premium     = function_exists( 'macm_fs' ) && macm_fs()->can_use_premium_code() && $macm_premium_files_exist;
		?>
		<?php if ( $macm_can_use_premium && ! empty( $classes ) ) : ?>
			<div class="kcm-form-section">
				<h3><?php esc_html_e( 'Select a Class (Optional)', 'martial-arts-club-manager' ); ?></h3>

				<div class="kcm-classes-list">
					<?php
					$macm_days = array(
						1 => __( 'Monday', 'martial-arts-club-manager' ),
						2 => __( 'Tuesday', 'martial-arts-club-manager' ),
						3 => __( 'Wednesday', 'martial-arts-club-manager' ),
						4 => __( 'Thursday', 'martial-arts-club-manager' ),
						5 => __( 'Friday', 'martial-arts-club-manager' ),
						6 => __( 'Saturday', 'martial-arts-club-manager' ),
						7 => __( 'Sunday', 'martial-arts-club-manager' ),
					);

					foreach ( $classes as $macm_class ) :
						$macm_day_name   = isset( $macm_days[ $macm_class->day_of_week ] ) ? $macm_days[ $macm_class->day_of_week ] : '';
						$macm_start_time = date_i18n( get_option( 'time_format' ), strtotime( $macm_class->start_time ) );
						$macm_end_time   = date_i18n( get_option( 'time_format' ), strtotime( $macm_class->end_time ) );
						$macm_location   = ! empty( $macm_class->location_name ) ? $macm_class->location_name : __( 'Location TBD', 'martial-arts-club-manager' );
						?>
						<label class="kcm-class-option">
							<input
								type="radio"
								name="class_id"
								value="<?php echo esc_attr( $macm_class->id ); ?>"
							/>
							<div class="kcm-class-details">
								<div class="kcm-class-title"><?php echo esc_html( $macm_class->name ); ?></div>
								<div class="kcm-class-schedule">
									<span class="kcm-class-day"><?php echo esc_html( $macm_day_name ); ?></span>
									<span class="kcm-class-time"><?php echo esc_html( $macm_start_time . ' - ' . $macm_end_time ); ?></span>
								</div>
								<div class="kcm-class-location">
									<span class="dashicons dashicons-location"></span>
									<?php echo esc_html( $macm_location ); ?>
								</div>
							</div>
						</label>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>

		<div class="kcm-form-actions">
			<button type="submit" class="kcm-submit-button">
				<?php esc_html_e( 'Book Trial Class', 'martial-arts-club-manager' ); ?>
			</button>
		</div>

		<div class="kcm-form-note">
			<span class="required">*</span>
			<?php esc_html_e( 'Required fields', 'martial-arts-club-manager' ); ?>
		</div>
	</form>
</div>
