<?php
/**
 * Template for Member Area
 *
 * Available variables:
 *
 * @var array $members Array of member objects
 *
 * @package KarateClubManager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$macm_belt_colors      = MACM_Member::get_belt_colors();
$macm_clubs            = ( class_exists( 'MACM_Club' ) ) ? MACM_Club::get_all( true ) : array(); // Get active clubs only (premium).
$macm_membership_types = MACM_Membership_Type::get_all( true ); // Get active membership types only.

// Check if premium files exist (free build doesn't include premium files).
// Used for UI gating when user has license but free build installed.
$macm_premium_files_exist = file_exists( MACM_PLUGIN_DIR . 'includes/classes/class-macm-location.php' );
$macm_can_use_premium     = function_exists( 'macm_fs' ) && macm_fs()->can_use_premium_code() && $macm_premium_files_exist;
?>

<div class="kcm-member-area">
	<div class="kcm-member-area-header">
		<h2><?php esc_html_e( 'My Members', 'martial-arts-club-manager' ); ?></h2>
		<button type="button" class="kcm-btn kcm-btn-primary" id="kcm-add-member-btn">
			<?php esc_html_e( 'Add New Member', 'martial-arts-club-manager' ); ?>
		</button>
	</div>

	<div id="kcm-messages"></div>

	<?php if ( empty( $members ) ) : ?>
		<div class="kcm-no-members">
			<p><?php esc_html_e( 'You have not added any members yet.', 'martial-arts-club-manager' ); ?></p>
			<p><?php esc_html_e( 'Click the "Add New Member" button above to get started.', 'martial-arts-club-manager' ); ?></p>
		</div>
	<?php else : ?>
		<div class="kcm-members-grid">
			<?php foreach ( $members as $macm_member ) : ?>
				<div class="kcm-member-card" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>">
					<div class="kcm-member-photo">
						<?php if ( $macm_member->photo_id ) : ?>
							<?php echo wp_get_attachment_image( $macm_member->photo_id, 'thumbnail', false, array( 'class' => 'kcm-member-img' ) ); ?>
							<button type="button" class="kcm-delete-photo-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>" title="<?php esc_attr_e( 'Delete Photo', 'martial-arts-club-manager' ); ?>">
								<span class="dashicons dashicons-no"></span>
							</button>
						<?php else : ?>
							<div class="kcm-member-placeholder">
								<span class="dashicons dashicons-admin-users"></span>
							</div>
						<?php endif; ?>

						<!-- Duplicate info overlay on the right side of photo -->
						<div class="kcm-photo-overlay">
							<div class="kcm-overlay-name"><?php echo esc_html( $macm_member->full_name ); ?></div>
							<div class="kcm-overlay-belt">
								<span class="kcm-belt-badge kcm-belt-<?php echo esc_attr( $macm_member->belt_color ); ?>">
									<?php echo esc_html( $macm_belt_colors[ $macm_member->belt_color ] ?? $macm_member->belt_color ); ?>
								</span>
							</div>
							<?php if ( $macm_member->membership_type ) : ?>
								<div class="kcm-overlay-membership">
									<span class="kcm-membership-badge kcm-membership-<?php echo esc_attr( $macm_member->membership_type ); ?>">
										<?php echo esc_html( ucfirst( $macm_member->membership_type ) ); ?>
									</span>
								</div>
							<?php endif; ?>
							<div class="kcm-overlay-status">
								<span class="kcm-status-badge kcm-status-<?php echo esc_attr( $macm_member->status ); ?>">
									<?php echo esc_html( 'active' === $macm_member->status ? __( 'Active', 'martial-arts-club-manager' ) : __( 'Archived', 'martial-arts-club-manager' ) ); ?>
								</span>
							</div>
						</div>

						<button type="button" class="kcm-upload-photo-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>">
							<?php esc_html_e( 'Upload Photo', 'martial-arts-club-manager' ); ?>
						</button>
					</div>

					<div class="kcm-member-details">
						<h3><?php echo esc_html( $macm_member->full_name ); ?></h3>

						<div class="kcm-member-info">
							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Date of Birth:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value"><?php echo esc_html( MACM_Member::format_date( $macm_member->date_of_birth ) ); ?></span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Age:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value"><?php echo esc_html( MACM_Member::calculate_age( $macm_member->date_of_birth ) ); ?> <?php esc_html_e( 'years', 'martial-arts-club-manager' ); ?></span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Belt Color:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<span class="kcm-belt-badge kcm-belt-<?php echo esc_attr( $macm_member->belt_color ); ?>">
										<?php echo esc_html( $macm_belt_colors[ $macm_member->belt_color ] ?? $macm_member->belt_color ); ?>
									</span>
								</span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Membership:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php if ( $macm_member->membership_type ) : ?>
										<span class="kcm-membership-badge kcm-membership-<?php echo esc_attr( $macm_member->membership_type ); ?>">
											<?php echo esc_html( ucfirst( $macm_member->membership_type ) ); ?>
										</span>
									<?php else : ?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
									<?php endif; ?>
								</span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Status:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<span class="kcm-status-badge kcm-status-<?php echo esc_attr( $macm_member->status ); ?>">
										<?php echo esc_html( 'active' === $macm_member->status ? __( 'Active', 'martial-arts-club-manager' ) : __( 'Archived', 'martial-arts-club-manager' ) ); ?>
									</span>
								</span>
							</div>

							<?php if ( $macm_can_use_premium ) : ?>
							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Club:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php
									if ( $macm_member->club_id && class_exists( 'MACM_Club' ) ) :
										$macm_club = MACM_Club::get( $macm_member->club_id );
										if ( $macm_club ) :
											echo esc_html( $macm_club->club_name );
										else :
											?>
											<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
											<?php
										endif;
									else :
										?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
										<?php
									endif;
									?>
								</span>
							</div>
							<?php endif; ?>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Weight:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php
									$macm_formatted_weight = MACM_Member::format_weight( $macm_member->weight );
									if ( $macm_formatted_weight ) :
										?>
										<?php echo esc_html( $macm_formatted_weight ); ?>
									<?php else : ?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
									<?php endif; ?>
								</span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'Height:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php
									$macm_formatted_height = MACM_Member::format_height( $macm_member->height );
									if ( $macm_formatted_height ) :
										?>
										<?php echo esc_html( $macm_formatted_height ); ?>
									<?php else : ?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
									<?php endif; ?>
								</span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'License Number:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php if ( $macm_member->license_number ) : ?>
										<?php echo esc_html( $macm_member->license_number ); ?>
									<?php else : ?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
									<?php endif; ?>
								</span>
							</div>

							<div class="kcm-info-row">
								<span class="kcm-info-label"><?php esc_html_e( 'License Expires:', 'martial-arts-club-manager' ); ?></span>
								<span class="kcm-info-value">
									<?php if ( $macm_member->license_expiration ) : ?>
										<?php echo esc_html( MACM_Member::format_date( $macm_member->license_expiration ) ); ?>
									<?php else : ?>
										<span class="kcm-info-empty"><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></span>
									<?php endif; ?>
								</span>
							</div>
						</div>
					</div>

					<div class="kcm-member-actions">
						<?php if ( $macm_can_use_premium ) : ?>
						<button type="button" class="kcm-btn kcm-btn-info kcm-view-classes-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>" data-member-name="<?php echo esc_attr( $macm_member->full_name ); ?>">
							<span class="dashicons dashicons-calendar-alt"></span>
							<?php esc_html_e( 'My Classes', 'martial-arts-club-manager' ); ?>
						</button>
						<button type="button" class="kcm-btn kcm-btn-info kcm-view-events-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>" data-member-name="<?php echo esc_attr( $macm_member->full_name ); ?>">
							<span class="dashicons dashicons-tickets-alt"></span>
							<?php esc_html_e( 'My Events', 'martial-arts-club-manager' ); ?>
						</button>
						<button type="button" class="kcm-btn kcm-btn-info kcm-view-belt-history-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>" data-member-name="<?php echo esc_attr( $macm_member->full_name ); ?>">
							<span class="dashicons dashicons-awards"></span>
							<?php esc_html_e( 'Belt History', 'martial-arts-club-manager' ); ?>
						</button>
						<?php endif; ?>
						<button type="button" class="kcm-btn kcm-btn-secondary kcm-edit-member-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>">
							<?php esc_html_e( 'Edit', 'martial-arts-club-manager' ); ?>
						</button>
						<button type="button" class="kcm-btn kcm-btn-danger kcm-delete-member-btn" data-member-id="<?php echo esc_attr( $macm_member->id ); ?>">
							<?php esc_html_e( 'Delete', 'martial-arts-club-manager' ); ?>
						</button>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>

<!-- Member Form Modal -->
<div id="kcm-member-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content">
		<div class="kcm-modal-header">
			<h3 id="kcm-modal-title"><?php esc_html_e( 'Add New Member', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body">
			<form id="kcm-member-form">
				<input type="hidden" name="member_id" id="kcm-member-id" value="">

				<div class="kcm-form-row">
					<label for="kcm-full-name">
						<?php esc_html_e( 'Full Name', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="text" id="kcm-full-name" name="full_name" required>
				</div>

				<div class="kcm-form-row">
					<label for="kcm-date-of-birth">
						<?php esc_html_e( 'Date of Birth', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="date" id="kcm-date-of-birth" name="date_of_birth" required>
				</div>

				<div class="kcm-form-row">
					<label for="kcm-belt-color">
						<?php esc_html_e( 'Belt Color', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<select id="kcm-belt-color" name="belt_color" required>
						<option value=""><?php esc_html_e( 'Select Belt Color', 'martial-arts-club-manager' ); ?></option>
						<?php foreach ( $macm_belt_colors as $macm_value => $macm_label ) : ?>
							<option value="<?php echo esc_attr( $macm_value ); ?>"><?php echo esc_html( $macm_label ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>

				<div class="kcm-form-row">
					<label for="kcm-membership-type">
						<?php esc_html_e( 'Membership Type', 'martial-arts-club-manager' ); ?>
						<?php if ( ! current_user_can( 'manage_options' ) ) : ?>
							<small class="kcm-field-note"><?php esc_html_e( '(Admin only)', 'martial-arts-club-manager' ); ?></small>
						<?php endif; ?>
					</label>
					<?php if ( current_user_can( 'manage_options' ) ) : ?>
						<select id="kcm-membership-type" name="membership_type_id">
							<option value=""><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></option>
							<?php foreach ( $macm_membership_types as $macm_type ) : ?>
								<option value="<?php echo esc_attr( $macm_type->id ); ?>"><?php echo esc_html( $macm_type->type_name ); ?></option>
							<?php endforeach; ?>
						</select>
					<?php else : ?>
						<input type="text" id="kcm-membership-type-display" class="kcm-readonly-field" value="" readonly disabled>
						<input type="hidden" id="kcm-membership-type" name="membership_type_id" value="">
						<p class="kcm-field-help"><?php esc_html_e( 'Membership type is set automatically when purchasing a membership product, or can be changed by an administrator.', 'martial-arts-club-manager' ); ?></p>
					<?php endif; ?>
				</div>

				<?php // PREMIUM: Club field only for premium users. ?>
				<?php if ( $macm_can_use_premium ) : ?>
				<div class="kcm-form-row">
					<label for="kcm-club"><?php esc_html_e( 'Club', 'martial-arts-club-manager' ); ?></label>
					<select id="kcm-club" name="club_id">
						<option value=""><?php esc_html_e( 'Not set', 'martial-arts-club-manager' ); ?></option>
						<?php foreach ( $macm_clubs as $macm_club ) : ?>
							<option value="<?php echo esc_attr( $macm_club->id ); ?>"><?php echo esc_html( $macm_club->club_name ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>
				<?php endif; ?>

				<?php
				$macm_unit_sys = get_option( 'macm_unit_system', 'metric' );
				$macm_wt_label = 'imperial' === $macm_unit_sys ? __( 'Weight (lbs)', 'martial-arts-club-manager' ) : __( 'Weight (kg)', 'martial-arts-club-manager' );
				$macm_ht_label = 'imperial' === $macm_unit_sys ? __( 'Height (inches)', 'martial-arts-club-manager' ) : __( 'Height (cm)', 'martial-arts-club-manager' );
				$macm_wt_max   = 'imperial' === $macm_unit_sys ? 1100 : 500;
				$macm_ht_max   = 'imperial' === $macm_unit_sys ? 120 : 300;
				?>
				<div class="kcm-form-row">
					<label for="kcm-weight"><?php echo esc_html( $macm_wt_label ); ?></label>
					<input type="number" id="kcm-weight" name="weight" step="0.1" min="0" max="<?php echo esc_attr( $macm_wt_max ); ?>">
				</div>

				<div class="kcm-form-row">
					<label for="kcm-height"><?php echo esc_html( $macm_ht_label ); ?></label>
					<input type="number" id="kcm-height" name="height" step="0.1" min="0" max="<?php echo esc_attr( $macm_ht_max ); ?>">
				</div>

				<div class="kcm-form-row">
					<label for="kcm-license-number"><?php esc_html_e( 'License Number', 'martial-arts-club-manager' ); ?></label>
					<input type="text" id="kcm-license-number" name="license_number" maxlength="100">
				</div>

				<div class="kcm-form-row">
					<label for="kcm-license-expiration"><?php esc_html_e( 'License Expiration', 'martial-arts-club-manager' ); ?></label>
					<input type="date" id="kcm-license-expiration" name="license_expiration">
				</div>

				<div class="kcm-modal-footer">
					<button type="button" class="kcm-btn kcm-btn-secondary kcm-modal-close">
						<?php esc_html_e( 'Cancel', 'martial-arts-club-manager' ); ?>
					</button>
					<button type="submit" class="kcm-btn kcm-btn-primary">
						<?php esc_html_e( 'Save Member', 'martial-arts-club-manager' ); ?>
					</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Photo Upload Form (Hidden) -->
<form id="kcm-photo-upload-form" style="display: none;">
	<input type="file" id="kcm-photo-input" name="photo" accept="image/jpeg,image/jpg,image/png,image/gif">
	<input type="hidden" id="kcm-photo-member-id" name="member_id">
</form>

<!-- PREMIUM: Member Classes Modal - wrapped for Freemius code stripping -->
<?php if ( $macm_can_use_premium ) : ?>
<div id="kcm-classes-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content kcm-modal-large">
		<div class="kcm-modal-header">
			<h3 id="kcm-classes-modal-title"><?php esc_html_e( 'My Enrolled Classes', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body" id="kcm-classes-content">
			<div class="kcm-loading"><?php esc_html_e( 'Loading classes...', 'martial-arts-club-manager' ); ?></div>
		</div>
	</div>
</div>

<!-- PREMIUM: Member Events Modal -->
<div id="kcm-events-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content kcm-modal-large">
		<div class="kcm-modal-header">
			<h3 id="kcm-events-modal-title"><?php esc_html_e( 'My Registered Events', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body" id="kcm-events-content">
			<div class="kcm-loading"><?php esc_html_e( 'Loading events...', 'martial-arts-club-manager' ); ?></div>
		</div>
	</div>
</div>

<!-- PREMIUM: Belt History Modal -->
<div id="kcm-belt-history-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content kcm-modal-large">
		<div class="kcm-modal-header">
			<h3 id="kcm-belt-history-modal-title"><?php esc_html_e( 'Belt Grading History', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body" id="kcm-belt-history-content">
			<div class="kcm-loading"><?php esc_html_e( 'Loading belt history...', 'martial-arts-club-manager' ); ?></div>
		</div>
		<div class="kcm-modal-footer">
			<button type="button" class="kcm-btn kcm-btn-secondary" id="kcm-export-belt-history-btn" style="display: none;">
				<span class="dashicons dashicons-download"></span>
				<?php esc_html_e( 'Export CSV', 'martial-arts-club-manager' ); ?>
			</button>
		</div>
	</div>
</div>
<?php endif; ?>
