<?php
/**
 * WooCommerce Settings Template
 *
 * Displays WooCommerce integration settings.
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Get current settings values.
$macm_member_selector_text     = get_option( 'macm_member_selector_text', __( 'Select a member for this product', 'martial-arts-club-manager' ) );
$macm_require_member_selection = get_option( 'macm_require_member_selection', 'yes' );
$macm_show_member_in_cart      = get_option( 'macm_show_member_in_cart', 'yes' );
$macm_show_member_in_checkout  = get_option( 'macm_show_member_in_checkout', 'yes' );
?>

<div class="kcm-woocommerce-settings">
	<form method="post" action="">
		<?php wp_nonce_field( 'macm_save_settings', 'macm_settings_nonce' ); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'WooCommerce Status', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<?php if ( class_exists( 'WooCommerce' ) ) : ?>
							<p>
								<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
								<strong><?php esc_html_e( 'WooCommerce is active', 'martial-arts-club-manager' ); ?></strong>
							</p>
							<p class="description">
								<?php
								/* translators: %s: WooCommerce version */
								printf( esc_html__( 'Version %s', 'martial-arts-club-manager' ), esc_html( WC()->version ) );
								?>
							</p>
						<?php else : ?>
							<p>
								<span class="dashicons dashicons-warning" style="color: #dc3232;"></span>
								<strong><?php esc_html_e( 'WooCommerce is not active', 'martial-arts-club-manager' ); ?></strong>
							</p>
							<p class="description">
								<?php esc_html_e( 'WooCommerce must be installed and activated for product integration features to work.', 'martial-arts-club-manager' ); ?>
							</p>
						<?php endif; ?>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_member_selector_text"><?php esc_html_e( 'Member Selector Text', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<input
							type="text"
							name="macm_member_selector_text"
							id="macm_member_selector_text"
							value="<?php echo esc_attr( $macm_member_selector_text ); ?>"
							class="regular-text"
						/>
						<p class="description">
							<?php esc_html_e( 'Text displayed above the member selector dropdown on product pages.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_require_member_selection"><?php esc_html_e( 'Require Member Selection', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<fieldset>
							<label>
								<input
									type="checkbox"
									name="macm_require_member_selection"
									id="macm_require_member_selection"
									value="yes"
									<?php checked( $macm_require_member_selection, 'yes' ); ?>
								/>
								<?php esc_html_e( 'Require customers to select a member before adding dojo products to cart', 'martial-arts-club-manager' ); ?>
							</label>
							<p class="description">
								<?php esc_html_e( 'When enabled, customers cannot add dojo products to cart without selecting a member.', 'martial-arts-club-manager' ); ?>
							</p>
						</fieldset>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'Display Options', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<fieldset>
							<label style="display: block; margin-bottom: 8px;">
								<input
									type="checkbox"
									name="macm_show_member_in_cart"
									value="yes"
									<?php checked( $macm_show_member_in_cart, 'yes' ); ?>
								/>
								<?php esc_html_e( 'Show member name in cart', 'martial-arts-club-manager' ); ?>
							</label>

							<label style="display: block; margin-bottom: 8px;">
								<input
									type="checkbox"
									name="macm_show_member_in_checkout"
									value="yes"
									<?php checked( $macm_show_member_in_checkout, 'yes' ); ?>
								/>
								<?php esc_html_e( 'Show member name in checkout', 'martial-arts-club-manager' ); ?>
							</label>

							<p class="description">
								<?php esc_html_e( 'Choose where to display the associated member name for dojo products.', 'martial-arts-club-manager' ); ?>
							</p>
						</fieldset>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'Dojo Products', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<?php
						// Count products marked as dojo products using WP_Query (WordPress API compliant).
						$macm_dojo_cache_key     = 'macm_dojo_product_count';
						$macm_dojo_product_count = wp_cache_get( $macm_dojo_cache_key, 'macm' );
						if ( false === $macm_dojo_product_count ) {
							// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query -- Admin settings page with caching (300s TTL), infrequent query.
							$macm_dojo_query         = new WP_Query(
								array(
									'post_type'      => 'product',
									'post_status'    => 'publish',
									'meta_query'     => array(
										array(
											'key'     => '_is_dojo_product',
											'value'   => 'yes',
											'compare' => '=',
										),
									),
									'posts_per_page' => -1,
									'fields'         => 'ids',
								)
							);
							$macm_dojo_product_count = $macm_dojo_query->found_posts;
							wp_cache_set( $macm_dojo_cache_key, $macm_dojo_product_count, 'macm', 300 );
						}
						?>
						<p>
							<strong><?php echo esc_html( $macm_dojo_product_count ); ?></strong>
							<?php
							/* translators: %s: number of products */
							echo esc_html( _n( 'product is marked as a dojo product', 'products are marked as dojo products', $macm_dojo_product_count, 'martial-arts-club-manager' ) );
							?>
						</p>
						<p class="description">
							<?php
							printf(
								/* translators: %s: link to products page */
								wp_kses_post( __( 'Dojo products require member association. Mark products as "Dojo Product" in the <a href="%s">product edit page</a>.', 'martial-arts-club-manager' ) ),
								esc_url( admin_url( 'edit.php?post_type=product' ) )
							);
							?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>

		<?php
		/**
		 * Action hook for adding custom WooCommerce settings fields.
		 *
		 * @since 1.0.0
		 */
		do_action( 'macm_woocommerce_settings_fields' );
		?>

		<?php submit_button( __( 'Save Settings', 'martial-arts-club-manager' ), 'primary', 'macm_settings_submit' ); ?>
	</form>
</div>
