<?php
/**
 * Settings - User Accounts Tab Template
 *
 * Displays members that are auto-assigned to admin and allows
 * bulk creation of WordPress user accounts for them.
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.319
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$macm_members_needing_user = macm_get_members_needing_wp_user();
?>

<div class="kcm-settings-section">
	<h2><?php esc_html_e( 'WordPress User Accounts', 'martial-arts-club-manager' ); ?></h2>
	<p class="description">
		<?php esc_html_e( 'Members listed below were added without their own WordPress user account and are currently assigned to your admin account. Create individual WordPress accounts so they can log in and manage their own profiles.', 'martial-arts-club-manager' ); ?>
	</p>

	<div class="notice notice-info inline" style="margin-bottom: 15px;">
		<p>
			<?php esc_html_e( 'When you click "Create WordPress Users", individual accounts will be created for each selected member. If two or more members share the same email address (e.g., siblings managed by the same parent), they will automatically be linked to the same WordPress user account — no duplicate accounts will be created.', 'martial-arts-club-manager' ); ?>
		</p>
	</div>

	<?php if ( empty( $macm_members_needing_user ) ) : ?>
		<div class="notice notice-info inline">
			<p><?php esc_html_e( 'All members have their own WordPress user accounts. No action needed.', 'martial-arts-club-manager' ); ?></p>
		</div>
	<?php else : ?>
		<div id="macm-bulk-user-messages"></div>

		<table class="wp-list-table widefat fixed striped" id="macm-bulk-user-table">
			<thead>
				<tr>
					<td class="manage-column column-cb check-column">
						<input type="checkbox" id="macm-bulk-user-select-all">
					</td>
					<th scope="col"><?php esc_html_e( 'Member Name', 'martial-arts-club-manager' ); ?></th>
					<th scope="col"><?php esc_html_e( 'Email', 'martial-arts-club-manager' ); ?></th>
					<th scope="col"><?php esc_html_e( 'Belt', 'martial-arts-club-manager' ); ?></th>
					<th scope="col"><?php esc_html_e( 'Status', 'martial-arts-club-manager' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $macm_members_needing_user as $macm_member ) : ?>
					<tr>
						<th scope="row" class="check-column">
							<input type="checkbox"
								class="macm-bulk-user-checkbox"
								value="<?php echo esc_attr( $macm_member->id ); ?>"
								data-member-id="<?php echo esc_attr( $macm_member->id ); ?>">
						</th>
						<td><?php echo esc_html( $macm_member->full_name ); ?></td>
						<td>
							<input type="email"
								class="macm-bulk-user-email regular-text"
								data-member-id="<?php echo esc_attr( $macm_member->id ); ?>"
								value="<?php echo esc_attr( $macm_member->email ); ?>"
								placeholder="<?php esc_attr_e( 'Enter email address', 'martial-arts-club-manager' ); ?>">
						</td>
						<td><?php echo esc_html( $macm_member->belt_color ); ?></td>
						<td><?php echo esc_html( $macm_member->status ); ?></td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<p class="submit">
			<button type="button" class="button button-primary" id="macm-bulk-create-users-btn" disabled>
				<?php esc_html_e( 'Create WordPress Users & Assign to Members', 'martial-arts-club-manager' ); ?>
			</button>
			<span class="spinner" id="macm-bulk-user-spinner" style="float: none;"></span>
		</p>
	<?php endif; ?>
</div>
