<?php
/**
 * Admin Settings Page Template
 *
 * Main settings page with tabbed interface.
 * Variables $tabs and $macm_current_tab are passed from the controller
 * (class-macm-admin-settings.php display_settings_page method).
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Variables are passed from controller - verify they exist.
if ( ! isset( $tabs ) || ! isset( $macm_current_tab ) ) {
	wp_die( esc_html__( 'This template must be loaded from the settings controller.', 'martial-arts-club-manager' ) );
}

?>

<div class="wrap kcm-settings-page">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<?php settings_errors( 'macm_settings' ); ?>

	<!-- Settings Tabs -->
	<nav class="nav-tab-wrapper wp-clearfix" aria-label="<?php esc_attr_e( 'Secondary menu', 'martial-arts-club-manager' ); ?>">
		<?php foreach ( $tabs as $macm_tab_slug => $macm_tab_label ) : ?>
			<?php
			$macm_tab_url      = add_query_arg(
				array(
					'page' => 'kcm-settings',
					'tab'  => $macm_tab_slug,
				),
				admin_url( 'admin.php' )
			);
			$macm_active_class = ( $macm_current_tab === $macm_tab_slug ) ? 'nav-tab-active' : '';
			?>
			<a href="<?php echo esc_url( $macm_tab_url ); ?>"
				class="nav-tab <?php echo esc_attr( $macm_active_class ); ?>">
				<?php echo esc_html( $macm_tab_label ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<!-- Settings Content -->
	<div class="kcm-settings-content">
		<?php
		// Load the appropriate tab content.
		switch ( $macm_current_tab ) {
			case 'general':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-general.php';
				break;

			case 'notifications':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-notifications.php';
				break;

			case 'woocommerce':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-woocommerce.php';
				break;

			case 'email':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-email.php';
				break;

			case 'email-design':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-email-design.php';
				break;

			case 'button-colours':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-button-colours.php';
				break;

			case 'user-accounts':
				include MACM_PLUGIN_DIR . 'templates/admin/settings-user-accounts.php';
				break;

			default:
				/**
				 * Action hook for custom settings tabs.
				 *
				 * Allows rendering custom tab content.
				 *
				 * @since 1.0.0
				 * @param string $macm_current_tab The current tab slug.
				 */
				do_action( 'macm_settings_tab_content_' . $macm_current_tab, $macm_current_tab );
				break;
		}
		?>
	</div>
</div>
