<?php
/**
 * Notifications Settings Template
 *
 * Displays the notification recipient settings interface.
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.320
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Get current settings values.
$macm_admin_email         = get_option( 'admin_email' );
$macm_member_notif_email  = get_option( 'macm_member_notification_email', '' );
$macm_trial_booking_notif = get_option( 'macm_trial_booking_notification_email', '' );
$macm_events_notif_email  = get_option( 'macm_events_notification_email', '' );
?>

<div class="kcm-notifications-settings">
	<form method="post" action="">
		<?php wp_nonce_field( 'macm_save_settings', 'macm_settings_nonce' ); ?>

		<p class="description" style="margin-bottom: 15px;">
			<?php esc_html_e( 'Configure which email addresses receive admin notifications. You can enter multiple email addresses separated by commas. If left empty, notifications will be sent to the site admin email.', 'martial-arts-club-manager' ); ?>
		</p>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label for="macm_member_notification_email"><?php esc_html_e( 'Member Registration & Deletion', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<input
							type="text"
							name="macm_member_notification_email"
							id="macm_member_notification_email"
							value="<?php echo esc_attr( $macm_member_notif_email ); ?>"
							class="large-text"
							placeholder="<?php echo esc_attr( $macm_admin_email ); ?>"
						/>
						<p class="description">
							<?php esc_html_e( 'Receives notifications when members are registered or deleted. Separate multiple emails with commas.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_trial_booking_notification_email"><?php esc_html_e( 'Trial Booking', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<input
							type="text"
							name="macm_trial_booking_notification_email"
							id="macm_trial_booking_notification_email"
							value="<?php echo esc_attr( $macm_trial_booking_notif ); ?>"
							class="large-text"
							placeholder="<?php echo esc_attr( $macm_admin_email ); ?>"
						/>
						<p class="description">
							<?php esc_html_e( 'Receives notifications when new trial class bookings are submitted. Separate multiple emails with commas.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_events_notification_email"><?php esc_html_e( 'Events (Default)', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<input
							type="text"
							name="macm_events_notification_email"
							id="macm_events_notification_email"
							value="<?php echo esc_attr( $macm_events_notif_email ); ?>"
							class="large-text"
							placeholder="<?php echo esc_attr( $macm_admin_email ); ?>"
						/>
						<p class="description">
							<?php esc_html_e( 'Default email for event registration notifications. Individual events can override this in the event form. Separate multiple emails with commas.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>

		<?php submit_button( __( 'Save Settings', 'martial-arts-club-manager' ), 'primary', 'macm_settings_submit' ); ?>
	</form>
</div>
