<?php
/**
 * General Settings Template
 *
 * Displays the general settings interface.
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Get instance of settings class.
$macm_settings = new MACM_Admin_Settings();

// Get current settings values.
$macm_date_format    = get_option( 'macm_date_format', 'Y-m-d' );
$macm_time_format    = get_option( 'macm_time_format', 'H:i' );
$macm_items_per_page = get_option( 'macm_items_per_page', 20 );
$macm_unit_system    = get_option( 'macm_unit_system', 'metric' );
?>

<div class="kcm-general-settings">
	<form method="post" action="">
		<?php wp_nonce_field( 'macm_save_settings', 'macm_settings_nonce' ); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'Plugin Information', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<p>
							<strong><?php esc_html_e( 'Version:', 'martial-arts-club-manager' ); ?></strong>
							<?php echo esc_html( MACM_VERSION ); ?>
						</p>
						<p class="description">
							<?php esc_html_e( 'Current plugin version installed on this site.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_date_format"><?php esc_html_e( 'Date Format', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<select name="macm_date_format" id="macm_date_format" class="regular-text">
							<option value="Y-m-d" <?php selected( $macm_date_format, 'Y-m-d' ); ?>>
								<?php echo esc_html( wp_date( 'Y-m-d' ) ); ?> (Y-m-d)
							</option>
							<option value="m/d/Y" <?php selected( $macm_date_format, 'm/d/Y' ); ?>>
								<?php echo esc_html( wp_date( 'm/d/Y' ) ); ?> (m/d/Y)
							</option>
							<option value="d/m/Y" <?php selected( $macm_date_format, 'd/m/Y' ); ?>>
								<?php echo esc_html( wp_date( 'd/m/Y' ) ); ?> (d/m/Y)
							</option>
							<option value="F j, Y" <?php selected( $macm_date_format, 'F j, Y' ); ?>>
								<?php echo esc_html( wp_date( 'F j, Y' ) ); ?> (F j, Y)
							</option>
							<option value="d-M-Y" <?php selected( $macm_date_format, 'd-M-Y' ); ?>>
								<?php echo esc_html( wp_date( 'd-M-Y' ) ); ?> (d-M-Y)
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'Date format used throughout the plugin.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_time_format"><?php esc_html_e( 'Time Format', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<select name="macm_time_format" id="macm_time_format" class="regular-text">
							<option value="H:i" <?php selected( $macm_time_format, 'H:i' ); ?>>
								<?php echo esc_html( wp_date( 'H:i' ) ); ?> (24-hour)
							</option>
							<option value="g:i A" <?php selected( $macm_time_format, 'g:i A' ); ?>>
								<?php echo esc_html( wp_date( 'g:i A' ) ); ?> (12-hour)
							</option>
							<option value="g:i a" <?php selected( $macm_time_format, 'g:i a' ); ?>>
								<?php echo esc_html( wp_date( 'g:i a' ) ); ?> (12-hour lowercase)
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'Time format used throughout the plugin.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_items_per_page"><?php esc_html_e( 'Items Per Page', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<input
							type="number"
							name="macm_items_per_page"
							id="macm_items_per_page"
							value="<?php echo esc_attr( $macm_items_per_page ); ?>"
							min="5"
							max="100"
							step="5"
							class="small-text"
						/>
						<p class="description">
							<?php esc_html_e( 'Number of items to display per page in admin lists (5-100).', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="macm_unit_system"><?php esc_html_e( 'Unit System', 'martial-arts-club-manager' ); ?></label>
					</th>
					<td>
						<select name="macm_unit_system" id="macm_unit_system" class="regular-text">
							<option value="metric" <?php selected( $macm_unit_system, 'metric' ); ?>>
								<?php esc_html_e( 'Metric (kg, cm)', 'martial-arts-club-manager' ); ?>
							</option>
							<option value="imperial" <?php selected( $macm_unit_system, 'imperial' ); ?>>
								<?php esc_html_e( 'Imperial (lbs, ft/in)', 'martial-arts-club-manager' ); ?>
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'Unit system for weight and height. Data is stored in metric internally.', 'martial-arts-club-manager' ); ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>

		<?php
		/**
		 * Action hook for adding custom general settings fields.
		 *
		 * @since 1.0.0
		 */
		do_action( 'macm_general_settings_fields' );
		?>

		<?php submit_button( __( 'Save Settings', 'martial-arts-club-manager' ), 'primary', 'macm_settings_submit' ); ?>
	</form>
</div>
