<?php
/**
 * Admin Data Reset Tab Template
 *
 * Displays the reset plugin data section with warnings and confirmation.
 * This is a destructive operation that cannot be undone.
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.266
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="macm-reset-section">
	<!-- Warning Header -->
	<div class="macm-reset-warning-header">
		<span class="dashicons dashicons-warning"></span>
		<h2><?php esc_html_e( 'Danger Zone', 'martial-arts-club-manager' ); ?></h2>
	</div>

	<!-- Warning Message -->
	<div class="macm-reset-warning-box">
		<h3><?php esc_html_e( 'Reset Plugin Content', 'martial-arts-club-manager' ); ?></h3>

		<p class="macm-reset-description">
			<?php esc_html_e( 'This action will permanently delete ALL plugin data from your database. This includes:', 'martial-arts-club-manager' ); ?>
		</p>

		<ul class="macm-reset-list">
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All members and their profiles', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All classes and schedules', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All attendance records', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All events and registrations', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All grading history', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All training videos', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All instructors, locations, clubs, and groups', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All belt colors and membership types', 'martial-arts-club-manager' ); ?></li>
			<li><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'All trial bookings', 'martial-arts-club-manager' ); ?></li>
		</ul>

		<div class="macm-reset-alert">
			<span class="dashicons dashicons-info"></span>
			<strong><?php esc_html_e( 'This action CANNOT be undone!', 'martial-arts-club-manager' ); ?></strong>
		</div>
	</div>

	<!-- Export First Suggestion -->
	<div class="macm-reset-suggestion">
		<span class="dashicons dashicons-download"></span>
		<div class="macm-suggestion-content">
			<strong><?php esc_html_e( 'Before you reset:', 'martial-arts-club-manager' ); ?></strong>
			<p>
				<?php
				printf(
					/* translators: %s: Export tab link */
					esc_html__( 'We strongly recommend %s to create a backup of your data. This allows you to restore your data if needed.', 'martial-arts-club-manager' ),
					'<a href="' . esc_url( admin_url( 'admin.php?page=macm-data&tab=export' ) ) . '">' . esc_html__( 'exporting your data first', 'martial-arts-club-manager' ) . '</a>'
				);
				?>
			</p>
		</div>
	</div>

	<!-- Reset Button -->
	<div class="macm-reset-action">
		<button type="button" id="macm-reset-btn" class="button macm-reset-button">
			<span class="dashicons dashicons-trash"></span>
			<?php esc_html_e( 'Reset Plugin Content', 'martial-arts-club-manager' ); ?>
		</button>
		<p class="macm-reset-hint">
			<?php esc_html_e( 'You will be asked to confirm this action.', 'martial-arts-club-manager' ); ?>
		</p>
	</div>

	<!-- Reset Progress (hidden by default) -->
	<div id="macm-reset-progress" class="macm-reset-progress" style="display: none;">
		<div class="macm-progress-bar">
			<div class="macm-progress-fill" style="width: 0%;"></div>
		</div>
		<div class="macm-progress-status">
			<span class="macm-progress-text"><?php esc_html_e( 'Resetting data...', 'martial-arts-club-manager' ); ?></span>
		</div>
	</div>

	<!-- Reset Results (hidden by default) -->
	<div id="macm-reset-results" class="macm-reset-results" style="display: none;">
		<div class="macm-results-icon"></div>
		<div class="macm-results-message"></div>
	</div>
</div>
