<?php
/**
 * Admin Data Export/Import Page Template
 *
 * Main data page with tabbed interface for export and import operations.
 * Variables $tabs, $current_tab, and $entities are passed from the controller
 * (class-macm-admin-data.php display_page method).
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/templates/admin
 * @since      1.0.265
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Variables are passed from controller - verify they exist.
if ( ! isset( $tabs ) || ! isset( $current_tab ) || ! isset( $entities ) ) {
	wp_die( esc_html__( 'This template must be loaded from the data controller.', 'martial-arts-club-manager' ) );
}
?>

<div class="wrap macm-data-page">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<?php settings_errors( 'macm_data' ); ?>

	<!-- Data Tabs -->
	<nav class="nav-tab-wrapper wp-clearfix" aria-label="<?php esc_attr_e( 'Data operations menu', 'martial-arts-club-manager' ); ?>">
		<?php foreach ( $tabs as $macm_tab_slug => $macm_tab_label ) : ?>
			<?php
			$macm_tab_url      = add_query_arg(
				array(
					'page' => 'macm-data',
					'tab'  => $macm_tab_slug,
				),
				admin_url( 'admin.php' )
			);
			$macm_active_class = ( $current_tab === $macm_tab_slug ) ? 'nav-tab-active' : '';

			// Set icon based on tab.
			switch ( $macm_tab_slug ) {
				case 'export':
					$macm_tab_icon = 'dashicons-download';
					break;
				case 'import':
					$macm_tab_icon = 'dashicons-upload';
					break;
				case 'reset':
					$macm_tab_icon = 'dashicons-trash';
					break;
				default:
					$macm_tab_icon = 'dashicons-admin-generic';
					break;
			}
			?>
			<a href="<?php echo esc_url( $macm_tab_url ); ?>"
				class="nav-tab <?php echo esc_attr( $macm_active_class ); ?>">
				<span class="dashicons <?php echo esc_attr( $macm_tab_icon ); ?>"></span>
				<?php echo esc_html( $macm_tab_label ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<!-- Data Content -->
	<div class="macm-data-content">
		<?php
		// Load the appropriate tab content.
		switch ( $current_tab ) {
			case 'export':
				include MACM_PLUGIN_DIR . 'templates/admin/data-export.php';
				break;

			case 'import':
				include MACM_PLUGIN_DIR . 'templates/admin/data-import.php';
				break;

			case 'reset':
				include MACM_PLUGIN_DIR . 'templates/admin/data-reset.php';
				break;

			default:
				/**
				 * Action hook for custom data tabs.
				 *
				 * @since 1.0.265
				 * @param string $current_tab The current tab slug.
				 * @param array  $entities    The exportable entities.
				 */
				do_action( 'macm_data_tab_content_' . sanitize_key( $current_tab ), $current_tab, $entities );
				break;
		}
		?>
	</div>
</div>
