<?php
/**
 * Admin Dashboard Template
 *
 * Enhanced dashboard with statistics, recent activity, and quick links.
 *
 * @package KarateClubManager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check if premium files exist (free build doesn't include premium files).
// Used for UI gating when user has license but free build installed.
$macm_premium_files_exist = file_exists( MACM_PLUGIN_DIR . 'includes/classes/class-macm-location.php' );
?>

<div class="wrap kcm-admin-wrapper">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Martial Arts Club Manager Dashboard', 'martial-arts-club-manager' ); ?></h1>

	<!-- Statistics Cards -->
	<div class="kcm-dashboard-stats" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 20px; margin: 30px 0;">

		<!-- Total Members -->
		<div class="kcm-stat-card" style="background: #FFFFFF; border: 1px solid #D1D5DB; padding: 25px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; color: #111827;">
			<div style="display: flex; justify-content: space-between; align-items: center;">
				<div>
					<h3 style="margin: 0 0 5px 0; color: #6B7280; font-size: 14px; font-weight: normal; text-transform: uppercase; letter-spacing: 0.5px;">
						<?php esc_html_e( 'Total Members', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 36px; font-weight: bold;"><?php echo esc_html( $total_members ); ?></p>
				</div>
				<span class="dashicons dashicons-groups" style="font-size: 48px; width: 48px; height: 48px; line-height: 48px; color: #B11226; opacity: 0.7;"></span>
			</div>
		</div>

		<?php // PREMIUM: Active Classes and Attendance stat cards - requires license AND premium files. ?>
		<?php if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) : ?>
		<!-- Active Classes -->
		<div class="kcm-stat-card" style="background: #FFFFFF; border: 1px solid #D1D5DB; padding: 25px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; color: #111827;">
			<div style="display: flex; justify-content: space-between; align-items: center;">
				<div>
					<h3 style="margin: 0 0 5px 0; color: #6B7280; font-size: 14px; font-weight: normal; text-transform: uppercase; letter-spacing: 0.5px;">
						<?php esc_html_e( 'Active Classes', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 36px; font-weight: bold;"><?php echo esc_html( $total_classes ); ?></p>
					<?php if ( isset( $total_locations ) ) : ?>
						<p style="margin: 5px 0 0 0; font-size: 12px; color: #6B7280;">
							<?php echo esc_html( $total_locations ); ?> <?php esc_html_e( 'Locations', 'martial-arts-club-manager' ); ?>
						</p>
					<?php endif; ?>
				</div>
				<span class="dashicons dashicons-calendar-alt" style="font-size: 48px; width: 48px; height: 48px; line-height: 48px; color: #B11226; opacity: 0.7;"></span>
			</div>
		</div>

		<!-- Attendance This Month -->
		<div class="kcm-stat-card" style="background: #FFFFFF; border: 1px solid #D1D5DB; padding: 25px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; color: #111827;">
			<div style="display: flex; justify-content: space-between; align-items: center;">
				<div>
					<h3 style="margin: 0 0 5px 0; color: #6B7280; font-size: 14px; font-weight: normal; text-transform: uppercase; letter-spacing: 0.5px;">
						<?php esc_html_e( 'Attendance This Month', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 36px; font-weight: bold;"><?php echo esc_html( $total_attendance ); ?></p>
					<?php if ( isset( $total_enrollments ) ) : ?>
						<p style="margin: 5px 0 0 0; font-size: 12px; color: #6B7280;">
							<?php echo esc_html( $total_enrollments ); ?> <?php esc_html_e( 'Total Enrollments', 'martial-arts-club-manager' ); ?>
						</p>
					<?php endif; ?>
				</div>
				<span class="dashicons dashicons-yes-alt" style="font-size: 48px; width: 48px; height: 48px; line-height: 48px; color: #B11226; opacity: 0.7;"></span>
			</div>
		</div>
		<?php endif; ?>

		<!-- Membership Breakdown -->
		<div class="kcm-stat-card" style="background: #FFFFFF; border: 1px solid #D1D5DB; padding: 25px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; color: #111827;">
			<div style="display: flex; justify-content: space-between; align-items: center;">
				<div>
					<h3 style="margin: 0 0 5px 0; color: #6B7280; font-size: 14px; font-weight: normal; text-transform: uppercase; letter-spacing: 0.5px;">
						<?php esc_html_e( 'Membership Types', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 36px; font-weight: bold;"><?php echo esc_html( $premium_members ); ?></p>
					<p style="margin: 5px 0 0 0; font-size: 12px; color: #6B7280;">
						<?php esc_html_e( 'Premium', 'martial-arts-club-manager' ); ?> /
						<?php echo esc_html( $basic_members ); ?> <?php esc_html_e( 'Basic', 'martial-arts-club-manager' ); ?>
					</p>
				</div>
				<span class="dashicons dashicons-star-filled" style="font-size: 48px; width: 48px; height: 48px; line-height: 48px; color: #B11226; opacity: 0.7;"></span>
			</div>
		</div>

	</div>

	<div class="kcm-dashboard-content" style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px; margin: 20px 0;">

		<!-- Recent Members -->
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 4px;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 1px solid #ddd; padding-bottom: 10px;"><?php esc_html_e( 'Recent Members', 'martial-arts-club-manager' ); ?></h2>

			<?php if ( $recent_members ) : ?>
				<table class="widefat striped">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Name', 'martial-arts-club-manager' ); ?></th>
							<th><?php esc_html_e( 'Belt', 'martial-arts-club-manager' ); ?></th>
							<th><?php esc_html_e( 'User', 'martial-arts-club-manager' ); ?></th>
							<th><?php esc_html_e( 'Added', 'martial-arts-club-manager' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $recent_members as $macm_member ) : ?>
							<tr>
								<td><strong><?php echo esc_html( $macm_member->full_name ); ?></strong></td>
								<td><?php echo esc_html( ucfirst( str_replace( '_', ' ', $macm_member->belt_color ) ) ); ?></td>
								<td><?php echo esc_html( $macm_member->user_display_name ); ?></td>
								<td><?php echo esc_html( MACM_Member::format_date( $macm_member->created_at, 'M j, Y' ) ); ?></td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
				<p style="margin: 15px 0 0 0; text-align: center;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-members' ) ); ?>" class="button">
						<?php esc_html_e( 'View All Members', 'martial-arts-club-manager' ); ?>
					</a>
				</p>
			<?php else : ?>
				<p><?php esc_html_e( 'No members added yet.', 'martial-arts-club-manager' ); ?></p>
				<p>
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-members' ) ); ?>" class="button button-primary">
						<?php esc_html_e( 'Add Your First Member', 'martial-arts-club-manager' ); ?>
					</a>
				</p>
			<?php endif; ?>
		</div>

		<!-- Quick Actions -->
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #B11226; padding-bottom: 10px; color: #111827;">
				<span class="dashicons dashicons-admin-links" style="vertical-align: middle;"></span>
				<?php esc_html_e( 'Quick Actions', 'martial-arts-club-manager' ); ?>
			</h2>

			<ul style="list-style: none; margin: 0; padding: 0;">
				<li style="margin: 0 0 12px 0;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-members' ) ); ?>" class="kcm-quick-link" style="display: flex; align-items: center; padding: 12px; background: #B11226; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s;">
						<span class="dashicons dashicons-groups" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Manage Members', 'martial-arts-club-manager' ); ?></span>
					</a>
				</li>
				<?php
				// PREMIUM: Classes, Attendance, and Email quick actions.
				// Requires license AND premium files exist.
				if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) :
					?>
				<li style="margin: 0 0 12px 0;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-classes' ) ); ?>" class="kcm-quick-link" style="display: flex; align-items: center; padding: 12px; background: #2F343A; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s;">
						<span class="dashicons dashicons-calendar-alt" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Manage Classes', 'martial-arts-club-manager' ); ?></span>
					</a>
				</li>
				<li style="margin: 0 0 12px 0;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-attendance' ) ); ?>" class="kcm-quick-link" style="display: flex; align-items: center; padding: 12px; background: #2F343A; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s;">
						<span class="dashicons dashicons-yes-alt" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Track Attendance', 'martial-arts-club-manager' ); ?></span>
					</a>
				</li>
				<li style="margin: 0 0 12px 0;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-send-email' ) ); ?>" class="kcm-quick-link" style="display: flex; align-items: center; padding: 12px; background: #2F343A; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s;">
						<span class="dashicons dashicons-email-alt" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Send Email', 'martial-arts-club-manager' ); ?></span>
					</a>
				</li>
					<?php
				endif;
				?>
				<li style="margin: 0 0 12px 0;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-settings' ) ); ?>" class="kcm-quick-link" style="display: flex; align-items: center; padding: 12px; background: #FFFFFF; border: 1px solid #D1D5DB; border-radius: 6px; text-decoration: none; color: #111827; transition: transform 0.2s;">
						<span class="dashicons dashicons-admin-settings" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Settings', 'martial-arts-club-manager' ); ?></span>
					</a>
				</li>
				<li style="margin: 0 0 12px 0;">
					<a href="https://martialartsclubmanager.com/user-documentation/" class="kcm-quick-link" target="_blank" style="display: flex; align-items: center; padding: 12px; background: #2F343A; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s;">
						<span class="dashicons dashicons-book-alt" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'View Documentation', 'martial-arts-club-manager' ); ?></span>
						<span class="dashicons dashicons-external" style="font-size: 16px; margin-left: auto;"></span>
					</a>
				</li>
			</ul>

			<h3 style="margin: 25px 0 10px 0; font-size: 14px; color: #6B7280; text-transform: uppercase; letter-spacing: 0.5px;">
				<?php esc_html_e( 'Support & Feedback', 'martial-arts-club-manager' ); ?>
			</h3>

			<ul style="list-style: none; margin: 0; padding: 0;">
				<li style="margin: 0 0 12px 0;">
					<button type="button" id="kcm-request-feature-btn" class="kcm-quick-link" style="width: 100%; display: flex; align-items: center; padding: 12px; background: #2F343A; border: none; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s; cursor: pointer;">
						<span class="dashicons dashicons-lightbulb" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Request a Feature', 'martial-arts-club-manager' ); ?></span>
					</button>
				</li>
				<li style="margin: 0 0 0 0;">
					<button type="button" id="kcm-report-bug-btn" class="kcm-quick-link" style="width: 100%; display: flex; align-items: center; padding: 12px; background: #B11226; border: none; border-radius: 6px; text-decoration: none; color: #fff; transition: transform 0.2s; cursor: pointer;">
						<span class="dashicons dashicons-warning" style="font-size: 20px; margin-right: 10px;"></span>
						<span><?php esc_html_e( 'Report a Bug', 'martial-arts-club-manager' ); ?></span>
					</button>
				</li>
			</ul>
		</div>

	</div>

	<?php // PREMIUM: Recent Attendance section - requires license AND premium files. ?>
	<?php if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) : ?>
	<!-- Recent Attendance -->
		<?php if ( isset( $recent_attendance ) && ! empty( $recent_attendance ) ) : ?>
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px; margin: 20px 0;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #D1D5DB; padding-bottom: 10px; color: #111827;">
				<span class="dashicons dashicons-yes-alt" style="vertical-align: middle;"></span>
				<?php esc_html_e( 'Recent Attendance', 'martial-arts-club-manager' ); ?>
			</h2>

			<table class="widefat striped">
				<thead>
					<tr>
						<th><?php esc_html_e( 'Member', 'martial-arts-club-manager' ); ?></th>
						<th><?php esc_html_e( 'Class', 'martial-arts-club-manager' ); ?></th>
						<th><?php esc_html_e( 'Date', 'martial-arts-club-manager' ); ?></th>
						<th><?php esc_html_e( 'Time', 'martial-arts-club-manager' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $recent_attendance as $macm_attendance ) : ?>
						<tr>
							<td><strong><?php echo esc_html( $macm_attendance->member_name ); ?></strong></td>
							<td><?php echo esc_html( $macm_attendance->class_name ); ?></td>
							<td><?php echo esc_html( date_i18n( 'M j, Y', strtotime( $macm_attendance->attendance_date ) ) ); ?></td>
							<td><?php echo esc_html( date_i18n( 'g:i A', strtotime( $macm_attendance->attendance_date ) ) ); ?></td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
			<p style="margin: 15px 0 0 0; text-align: center;">
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-attendance' ) ); ?>" class="button">
					<?php esc_html_e( 'View All Attendance', 'martial-arts-club-manager' ); ?>
				</a>
			</p>
		</div>
	<?php endif; ?>
	<?php endif; ?>

	<!-- Three Column Widget Section -->
	<div class="kcm-dashboard-widgets" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin: 20px 0;">

		<!-- Recent Trial Bookings -->
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #D1D5DB; padding-bottom: 10px; color: #111827;">
				<span class="dashicons dashicons-clipboard" style="vertical-align: middle;"></span>
				<?php esc_html_e( 'Recent Trial Bookings', 'martial-arts-club-manager' ); ?>
			</h2>

			<?php if ( isset( $recent_trial_bookings ) && ! empty( $recent_trial_bookings ) ) : ?>
				<ul style="list-style: none; margin: 0; padding: 0;">
					<?php foreach ( $recent_trial_bookings as $macm_booking ) : ?>
						<li style="padding: 10px 0; border-bottom: 1px solid #F4F4F2;">
							<div style="display: flex; justify-content: space-between; align-items: start;">
								<div>
									<strong><?php echo esc_html( $macm_booking->full_name ); ?></strong>
									<?php if ( $macm_booking->is_for_child && ! empty( $macm_booking->parent_name ) ) : ?>
										<div style="font-size: 12px; color: #6B7280; margin-top: 3px;">
											<?php esc_html_e( 'Parent:', 'martial-arts-club-manager' ); ?> <?php echo esc_html( $macm_booking->parent_name ); ?>
										</div>
									<?php endif; ?>
									<div style="font-size: 12px; color: #6B7280; margin-top: 3px;">
										<?php echo esc_html( $macm_booking->email ); ?> • <?php echo esc_html( $macm_booking->mobile ); ?>
									</div>
									<div style="font-size: 11px; color: #6B7280; margin-top: 2px;">
										<?php echo esc_html( date_i18n( 'M j, Y g:i A', strtotime( $macm_booking->created_at ) ) ); ?>
									</div>
								</div>
							</div>
						</li>
					<?php endforeach; ?>
				</ul>
				<p style="margin: 15px 0 0 0; text-align: center;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-trial-bookings' ) ); ?>" class="button button-small">
						<?php esc_html_e( 'View All Bookings', 'martial-arts-club-manager' ); ?>
					</a>
				</p>
			<?php else : ?>
				<p style="color: #6B7280; font-style: italic;"><?php esc_html_e( 'No recent trial bookings.', 'martial-arts-club-manager' ); ?></p>
			<?php endif; ?>
		</div>

		<?php
		// PREMIUM: Upcoming Events widget - requires license AND premium files.
		if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) :
			?>
		<!-- Upcoming Events -->
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #D1D5DB; padding-bottom: 10px; color: #111827;">
				<span class="dashicons dashicons-calendar" style="vertical-align: middle;"></span>
			<?php esc_html_e( 'Upcoming Events', 'martial-arts-club-manager' ); ?>
			</h2>

			<?php if ( isset( $upcoming_events ) && ! empty( $upcoming_events ) ) : ?>
				<ul style="list-style: none; margin: 0; padding: 0;">
					<?php foreach ( $upcoming_events as $macm_event ) : ?>
						<li style="padding: 10px 0; border-bottom: 1px solid #F4F4F2;">
							<div>
								<strong><?php echo esc_html( $macm_event->title ); ?></strong>
								<div style="font-size: 12px; color: #6B7280; margin-top: 3px;">
									<span class="dashicons dashicons-calendar-alt" style="font-size: 14px; vertical-align: middle;"></span>
									<?php echo esc_html( date_i18n( 'M j, Y', strtotime( $macm_event->start_date ) ) ); ?>
									<?php if ( $macm_event->start_date !== $macm_event->end_date ) : ?>
										- <?php echo esc_html( date_i18n( 'M j, Y', strtotime( $macm_event->end_date ) ) ); ?>
									<?php endif; ?>
								</div>
								<?php if ( ! empty( $macm_event->location ) ) : ?>
									<div style="font-size: 11px; color: #6B7280; margin-top: 2px;">
										<span class="dashicons dashicons-location" style="font-size: 12px; vertical-align: middle;"></span>
										<?php echo esc_html( $macm_event->location ); ?>
									</div>
								<?php endif; ?>
							</div>
						</li>
					<?php endforeach; ?>
				</ul>
				<p style="margin: 15px 0 0 0; text-align: center;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-events' ) ); ?>" class="button button-small">
						<?php esc_html_e( 'View All Events', 'martial-arts-club-manager' ); ?>
					</a>
				</p>
			<?php else : ?>
				<p style="color: #6B7280; font-style: italic;"><?php esc_html_e( 'No upcoming events.', 'martial-arts-club-manager' ); ?></p>
			<?php endif; ?>
		</div>
			<?php
			endif;
		?>

		<?php
		// PREMIUM: Expiring Licenses widget - requires license AND premium files.
		if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) :
			?>
		<!-- Expiring Licenses -->
		<div class="kcm-dashboard-section" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h2 style="margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #d63638; padding-bottom: 10px; color: #d63638;">
				<span class="dashicons dashicons-warning" style="vertical-align: middle;"></span>
			<?php esc_html_e( 'Expiring Licenses', 'martial-arts-club-manager' ); ?>
			</h2>

			<?php if ( isset( $expiring_licenses ) && ! empty( $expiring_licenses ) ) : ?>
				<ul style="list-style: none; margin: 0; padding: 0;">
					<?php foreach ( $expiring_licenses as $macm_member ) : ?>
						<?php
						$macm_days_until_expiry = ceil( ( strtotime( $macm_member->license_expiration ) - time() ) / ( 60 * 60 * 24 ) );
						$macm_urgency_color     = $macm_days_until_expiry <= 7 ? '#d63638' : ( $macm_days_until_expiry <= 14 ? '#dba617' : '#6B7280' );
						?>
						<li style="padding: 10px 0; border-bottom: 1px solid #F4F4F2;">
							<div style="display: flex; justify-content: space-between; align-items: start;">
								<div>
									<strong><?php echo esc_html( $macm_member->full_name ); ?></strong>
									<div style="font-size: 12px; color: #6B7280; margin-top: 3px;">
										<?php echo esc_html( $macm_member->user_display_name ); ?>
									</div>
									<div style="font-size: 11px; color: <?php echo esc_attr( $macm_urgency_color ); ?>; margin-top: 2px; font-weight: 600;">
										<span class="dashicons dashicons-clock" style="font-size: 12px; vertical-align: middle;"></span>
										<?php
										/* translators: %d: number of days */
										echo esc_html( sprintf( _n( '%d day', '%d days', $macm_days_until_expiry, 'martial-arts-club-manager' ), $macm_days_until_expiry ) );
										?>
									</div>
								</div>
								<div style="text-align: right; font-size: 11px; color: #6B7280;">
									<?php echo esc_html( date_i18n( 'M j', strtotime( $macm_member->license_expiration ) ) ); ?>
								</div>
							</div>
						</li>
					<?php endforeach; ?>
				</ul>
				<p style="margin: 15px 0 0 0; text-align: center;">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-members' ) ); ?>" class="button button-small">
						<?php esc_html_e( 'Manage Members', 'martial-arts-club-manager' ); ?>
					</a>
				</p>
			<?php else : ?>
				<p style="color: #6B7280; font-style: italic;"><?php esc_html_e( 'No licenses expiring in the next 30 days.', 'martial-arts-club-manager' ); ?></p>
			<?php endif; ?>
		</div>
			<?php
			endif;
		?>

	</div>

	<?php
	// PREMIUM: Welcome / Getting Started section with 3-step setup guide.
	// References premium features (locations, groups, classes, attendance).
	// Requires license AND premium files.
	if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) :
		?>
	<!-- Welcome / Getting Started -->
		<?php if ( 0 === $total_members ) : ?>
		<div class="kcm-dashboard-welcome" style="background: #1C1C1E; padding: 30px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; margin: 20px 0; color: #fff;">
			<h2 style="color: #fff; margin-top: 0;">
				<span class="dashicons dashicons-welcome-learn-more" style="vertical-align: middle;"></span>
				<?php esc_html_e( 'Welcome to Martial Arts Club Manager!', 'martial-arts-club-manager' ); ?>
			</h2>
			<p style="font-size: 16px; line-height: 1.6;">
				<?php esc_html_e( 'Get started managing your martial arts club with these simple steps:', 'martial-arts-club-manager' ); ?>
			</p>

			<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin: 20px 0;">
				<div style="background: rgba(255,255,255,0.2); padding: 15px; border-radius: 6px;">
					<h3 style="color: #fff; margin: 0 0 8px 0; font-size: 16px;">
						<span class="dashicons dashicons-admin-site-alt3" style="vertical-align: middle;"></span>
						<?php esc_html_e( 'Step 1: Setup', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 14px;">
						<?php esc_html_e( 'Configure locations, groups, and class schedules.', 'martial-arts-club-manager' ); ?>
					</p>
				</div>
				<div style="background: rgba(255,255,255,0.2); padding: 15px; border-radius: 6px;">
					<h3 style="color: #fff; margin: 0 0 8px 0; font-size: 16px;">
						<span class="dashicons dashicons-groups" style="vertical-align: middle;"></span>
						<?php esc_html_e( 'Step 2: Members', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 14px;">
						<?php esc_html_e( 'Add members and assign them to classes.', 'martial-arts-club-manager' ); ?>
					</p>
				</div>
				<div style="background: rgba(255,255,255,0.2); padding: 15px; border-radius: 6px;">
					<h3 style="color: #fff; margin: 0 0 8px 0; font-size: 16px;">
						<span class="dashicons dashicons-yes-alt" style="vertical-align: middle;"></span>
						<?php esc_html_e( 'Step 3: Track', 'martial-arts-club-manager' ); ?>
					</h3>
					<p style="margin: 0; font-size: 14px;">
						<?php esc_html_e( 'Track attendance and monitor progress.', 'martial-arts-club-manager' ); ?>
					</p>
				</div>
			</div>

			<p style="text-align: center; margin: 25px 0 0 0;">
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=kcm-members' ) ); ?>" class="button button-primary button-hero" style="background: #fff; color: #B11226; border: none; text-shadow: none; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">
					<?php esc_html_e( 'Get Started', 'martial-arts-club-manager' ); ?>
				</a>
			</p>
		</div>
		<?php endif; ?>
		<?php
	endif;
	?>

	<!-- Charts Section -->
	<div class="kcm-dashboard-charts" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 20px; margin: 20px 0;">

		<?php // PREMIUM: Attendance Trends Chart - requires license AND premium files. ?>
		<?php if ( macm_fs()->can_use_premium_code() && $macm_premium_files_exist ) : ?>
		<!-- Attendance Trends Chart -->
		<div class="kcm-chart-card" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h3 style="margin: 0 0 15px 0; font-size: 16px; color: #111827; display: flex; align-items: center; gap: 8px;">
				<span class="dashicons dashicons-chart-bar" style="color: #B11226;"></span>
				<?php esc_html_e( 'Attendance Trends (Last 6 Months)', 'martial-arts-club-manager' ); ?>
			</h3>
			<div class="kcm-chart-container" style="position: relative; height: 250px;">
				<canvas id="kcm-attendance-chart"></canvas>
			</div>
			<p id="kcm-attendance-no-data" style="display: none; text-align: center; color: #6B7280; padding: 40px 0;">
				<?php esc_html_e( 'No attendance data available yet.', 'martial-arts-club-manager' ); ?>
			</p>
		</div>
		<?php endif; ?>

		<!-- Belt Distribution Chart -->
		<div class="kcm-chart-card" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h3 style="margin: 0 0 15px 0; font-size: 16px; color: #111827; display: flex; align-items: center; gap: 8px;">
				<span class="dashicons dashicons-awards" style="color: #B11226;"></span>
				<?php esc_html_e( 'Belt Distribution', 'martial-arts-club-manager' ); ?>
			</h3>
			<div class="kcm-chart-container" style="position: relative; height: 250px;">
				<canvas id="kcm-belt-chart"></canvas>
			</div>
			<p id="kcm-belt-no-data" style="display: none; text-align: center; color: #6B7280; padding: 40px 0;">
				<?php esc_html_e( 'No members with belt colors yet.', 'martial-arts-club-manager' ); ?>
			</p>
		</div>

		<!-- Membership Distribution Chart -->
		<div class="kcm-chart-card" style="background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 8px;">
			<h3 style="margin: 0 0 15px 0; font-size: 16px; color: #111827; display: flex; align-items: center; gap: 8px;">
				<span class="dashicons dashicons-groups" style="color: #B11226;"></span>
				<?php esc_html_e( 'Membership Types', 'martial-arts-club-manager' ); ?>
			</h3>
			<div class="kcm-chart-container" style="position: relative; height: 250px;">
				<canvas id="kcm-membership-chart"></canvas>
			</div>
			<p id="kcm-membership-no-data" style="display: none; text-align: center; color: #6B7280; padding: 40px 0;">
				<?php esc_html_e( 'No membership data available.', 'martial-arts-club-manager' ); ?>
			</p>
		</div>

	</div>

</div>

<!-- Request Feature Modal -->
<div id="kcm-feature-request-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content" style="max-width: 600px;">
		<div class="kcm-modal-header">
			<h3><?php esc_html_e( 'Request a Feature', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body">
			<p><?php esc_html_e( 'Have an idea for a new feature? We\'d love to hear it!', 'martial-arts-club-manager' ); ?></p>
			<form id="kcm-feature-request-form">
				<div class="kcm-form-row">
					<label for="feature-name">
						<?php esc_html_e( 'Your Name', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="text" id="feature-name" name="name" required>
				</div>

				<div class="kcm-form-row">
					<label for="feature-email">
						<?php esc_html_e( 'Your Email', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="email" id="feature-email" name="email" required>
				</div>

				<div class="kcm-form-row">
					<label for="feature-explanation">
						<?php esc_html_e( 'Feature Explanation', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<textarea id="feature-explanation" name="explanation" rows="6" style="width: 100%; padding: 10px; border: 1px solid #D1D5DB; border-radius: 4px; font-size: 14px;" required placeholder="<?php esc_attr_e( 'Please describe the feature you\'d like to see...', 'martial-arts-club-manager' ); ?>"></textarea>
				</div>

				<div class="kcm-modal-footer" style="margin-top: 20px;">
					<button type="button" class="button kcm-modal-close-btn"><?php esc_html_e( 'Cancel', 'martial-arts-club-manager' ); ?></button>
					<button type="submit" class="button button-primary"><?php esc_html_e( 'Submit Feature Request', 'martial-arts-club-manager' ); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Report Bug Modal -->
<div id="kcm-bug-report-modal" class="kcm-modal" style="display: none;">
	<div class="kcm-modal-content" style="max-width: 600px;">
		<div class="kcm-modal-header">
			<h3><?php esc_html_e( 'Report a Bug', 'martial-arts-club-manager' ); ?></h3>
			<button type="button" class="kcm-modal-close">&times;</button>
		</div>
		<div class="kcm-modal-body">
			<p><?php esc_html_e( 'Found a bug? Please let us know so we can fix it!', 'martial-arts-club-manager' ); ?></p>
			<form id="kcm-bug-report-form">
				<div class="kcm-form-row">
					<label for="bug-url">
						<?php esc_html_e( 'Page URL', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="url" id="bug-url" name="url" required placeholder="<?php esc_attr_e( 'https://...', 'martial-arts-club-manager' ); ?>">
				</div>

				<div class="kcm-form-row">
					<label for="bug-page">
						<?php esc_html_e( 'Page/Section', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<input type="text" id="bug-page" name="page" required placeholder="<?php esc_attr_e( 'e.g., Member Management, Class Schedule, etc.', 'martial-arts-club-manager' ); ?>">
				</div>

				<div class="kcm-form-row">
					<label for="bug-description">
						<?php esc_html_e( 'Bug Description', 'martial-arts-club-manager' ); ?> <span class="required">*</span>
					</label>
					<textarea id="bug-description" name="description" rows="6" style="width: 100%; padding: 10px; border: 1px solid #D1D5DB; border-radius: 4px; font-size: 14px;" required placeholder="<?php esc_attr_e( 'Please describe what happened, what you expected, and how to reproduce the bug...', 'martial-arts-club-manager' ); ?>"></textarea>
				</div>

				<div class="kcm-form-row">
					<label for="bug-screenshots">
						<?php esc_html_e( 'Screenshots (up to 3)', 'martial-arts-club-manager' ); ?>
					</label>
					<input type="file" id="bug-screenshots" name="screenshots[]" accept="image/*" multiple style="width: 100%;">
					<p class="description" style="margin-top: 5px; font-size: 12px; color: #6B7280;">
						<?php esc_html_e( 'You can upload up to 3 screenshots (PNG, JPG, GIF)', 'martial-arts-club-manager' ); ?>
					</p>
				</div>

				<div class="kcm-modal-footer" style="margin-top: 20px;">
					<button type="button" class="button kcm-modal-close-btn"><?php esc_html_e( 'Cancel', 'martial-arts-club-manager' ); ?></button>
					<button type="submit" class="button button-primary"><?php esc_html_e( 'Submit Bug Report', 'martial-arts-club-manager' ); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php
// Enqueue inline styles for dashboard modal using WordPress-compliant method.
$macm_dashboard_modal_styles = '
.kcm-quick-link:hover {
	transform: translateY(-2px);
	box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

.kcm-modal {
	display: none;
	position: fixed;
	z-index: 999999;
	left: 0;
	top: 0;
	width: 100%;
	height: 100%;
	max-width: none;
	overflow: auto;
	background-color: rgba(0, 0, 0, 0.6);
	padding: 40px 20px;
	box-sizing: border-box;
}

.kcm-modal-content {
	background-color: #fff;
	padding: 0;
	border-radius: 8px;
	width: 100%;
	max-width: 600px;
	box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
}

.kcm-modal-header {
	display: flex;
	justify-content: space-between;
	align-items: center;
	padding: 20px 25px;
	border-bottom: 1px solid #ddd;
	background: #F4F4F2;
	border-radius: 8px 8px 0 0;
}

.kcm-modal-header h3 {
	margin: 0;
	font-size: 20px;
	color: #111827;
}

.kcm-modal-close {
	font-size: 32px;
	font-weight: bold;
	color: #6B7280;
	background: none;
	border: none;
	cursor: pointer;
	line-height: 1;
	padding: 0;
	width: 30px;
	height: 30px;
	display: flex;
	align-items: center;
	justify-content: center;
	transition: color 0.3s ease;
}

.kcm-modal-close:hover {
	color: #111827;
}

.kcm-modal-body {
	padding: 25px;
}

.kcm-modal-footer {
	display: flex;
	justify-content: flex-end;
	align-items: center;
	gap: 12px;
	padding-top: 20px;
	border-top: 1px solid #F4F4F2;
}

.kcm-form-row {
	margin-bottom: 20px;
}

.kcm-form-row label {
	display: block;
	margin-bottom: 8px;
	font-weight: 600;
	color: #111827;
	font-size: 14px;
}

.kcm-form-row .required {
	color: #d63638;
}

.kcm-form-row input[type="text"],
.kcm-form-row input[type="email"],
.kcm-form-row input[type="url"] {
	width: 100%;
	padding: 10px 12px;
	border: 1px solid #D1D5DB;
	border-radius: 4px;
	font-size: 14px;
	transition: border-color 0.3s ease;
}

.kcm-form-row input:focus,
.kcm-form-row textarea:focus {
	outline: none;
	border-color: #B11226;
	box-shadow: 0 0 0 1px #B11226;
}
';
wp_add_inline_style( 'kcm-admin-dashboard', $macm_dashboard_modal_styles );
?>
