<?php
/**
 * Public Shortcodes
 *
 * Handles all public-facing shortcodes
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/includes/public
 * @since      1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class MACM_Shortcodes
 *
 * Registers and handles public shortcodes
 *
 * @since 1.0.0
 */
class MACM_Shortcodes {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_shortcode( 'macm_class_schedule', array( $this, 'class_schedule_shortcode' ) );
	}

	/**
	 * Class schedule shortcode
	 *
	 * Displays the weekly class schedule
	 *
	 * Usage: [macm_class_schedule] or [macm_class_schedule location_id="1"]
	 *
	 * @since 1.0.0
	 * @param array $atts Shortcode attributes.
	 * @return string HTML output.
	 */
	public function class_schedule_shortcode( $atts ) {
		// Parse attributes.
		$atts = shortcode_atts(
			array(
				'location_id' => '',
			),
			$atts,
			'macm_class_schedule'
		);

		// Build query args.
		$args = array(
			'is_archived' => 0,
			'orderby'     => 'day_of_week',
			'order'       => 'ASC',
		);

		if ( ! empty( $atts['location_id'] ) ) {
			$args['location_id'] = absint( $atts['location_id'] );
		}

		// Get classes.
		$classes = MACM_Class::get_all( $args );

		// Get all locations for filter.
		$locations = MACM_Location::get_all();

		// Group classes by day.
		$classes_by_day = array();
		for ( $i = 0; $i <= 6; $i++ ) {
			$classes_by_day[ $i ] = array();
		}

		foreach ( $classes as $class ) {
			$classes_by_day[ $class->day_of_week ][] = $class;
		}

		// Start output buffering.
		ob_start();

		// Load template.
		include MACM_PLUGIN_DIR . 'templates/public/class-schedule.php';

		return ob_get_clean();
	}
}

// Initialize.
new MACM_Shortcodes();
