<?php
/**
 * Create Trial Bookings Table
 *
 * @package    Karate_Club_Manager
 * @subpackage Karate_Club_Manager/includes/database
 * @since      1.0.61
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Create trial bookings table
 *
 * @since 1.0.61
 */
function macm_create_trial_bookings_table() {
	global $wpdb;

	$table_name           = $wpdb->prefix . 'macm_trial_bookings';
	$macm_charset_collate = $wpdb->get_charset_collate();

	$sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
		full_name varchar(255) NOT NULL,
		is_for_child tinyint(1) DEFAULT 0,
		parent_name varchar(255) DEFAULT NULL,
		mobile varchar(20) DEFAULT NULL,
		email varchar(100) NOT NULL,
		class_id bigint(20) DEFAULT NULL,
		status varchar(20) DEFAULT 'pending',
		created_at datetime DEFAULT CURRENT_TIMESTAMP,
		completed_at datetime DEFAULT NULL,
		PRIMARY KEY  (id),
		KEY class_id (class_id),
		KEY status (status),
		KEY created_at (created_at)
	) $macm_charset_collate;";

	require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	dbDelta( $sql );

	// Set default options.
	add_option( 'macm_trial_booking_success_message', __( 'Thank you for booking a trial lesson. A member of our team will contact you as soon as possible to confirm availability.', 'martial-arts-club-manager' ) );
}
