<?php
/**
 * Plugin deactivation handler
 *
 * @package KarateClubManager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles plugin deactivation
 */
class MACM_Deactivator {
	/**
	 * Deactivate the plugin
	 *
	 * This method is called when the plugin is deactivated.
	 * It performs cleanup tasks like flushing rewrite rules.
	 *
	 * Note: We do NOT delete data here. Data deletion is handled in uninstall.php
	 */
	public static function deactivate() {
		// Flush rewrite rules.
		flush_rewrite_rules();

		// Unschedule license expiration cron job (PREMIUM feature).
		if ( class_exists( 'MACM_License_Reminders' ) ) {
			MACM_License_Reminders::unschedule_cron();
		}

		// Clean up temporary data only (if any).
		// Do NOT delete permanent data like database tables, options, or user roles.
	}
}
