/**
 * Class Schedule JavaScript
 * Handles location filtering for the public class schedule
 *
 * @package Martial_Arts_Club_Manager
 * @version 1.0.174
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		/**
		 * Location Filter
		 * Filter class schedule by location
		 */
		$('#kcm-location-filter').on('change', function() {
			var locationId = $(this).val();

			if (locationId === '') {
				// Show all classes
				$('.kcm-class-card').show();
				$('.kcm-schedule-day').show();
			} else {
				// Hide all classes first
				$('.kcm-class-card').hide();

				// Show only classes at selected location
				$('.kcm-class-card[data-location-id="' + locationId + '"]').show();

				// Hide days with no visible classes
				$('.kcm-schedule-day').each(function() {
					var visibleClasses = $(this).find('.kcm-class-card:visible').length;
					if (visibleClasses === 0) {
						$(this).hide();
					} else {
						$(this).show();
					}
				});
			}
		});
	});

})(jQuery);
