/**
 * Admin Settings Page JavaScript
 *
 * @package Karate_Club_Manager
 * @since 1.0.0
 */

(function($) {
	'use strict';

	/**
	 * Initialize settings page functionality
	 */
	function initSettings() {
		// Select All / Deselect All is already handled inline in the template
		// Additional JavaScript functionality can be added here as needed

		// Show a confirmation message when changing protection settings
		$('.kcm-page-checkbox').on('change', function() {
			var checkbox = $(this);
			var pageName = checkbox.parent().find('strong').text();

			// Optional: Add visual feedback
			if (checkbox.is(':checked')) {
				checkbox.parent().addClass('page-protected');
			} else {
				checkbox.parent().removeClass('page-protected');
			}
		});
	}

	/**
	 * Button Colours Settings - Color Picker Sync
	 */
	function initButtonColoursPicker() {
		// Check if button colours elements exist
		if ($('#kcm_button_gradient_start').length === 0) {
			return;
		}

		// Sync color picker with text input
		$('#kcm_button_gradient_start').on('input', function() {
			$('#kcm_button_gradient_start_text').val($(this).val());
			updateButtonPreview();
		});

		$('#kcm_button_gradient_start_text').on('input', function() {
			var color = $(this).val();
			if (/^#[0-9A-Fa-f]{6}$/.test(color)) {
				$('#kcm_button_gradient_start').val(color);
				updateButtonPreview();
			}
		});

		$('#kcm_button_gradient_end').on('input', function() {
			$('#kcm_button_gradient_end_text').val($(this).val());
			updateButtonPreview();
		});

		$('#kcm_button_gradient_end_text').on('input', function() {
			var color = $(this).val();
			if (/^#[0-9A-Fa-f]{6}$/.test(color)) {
				$('#kcm_button_gradient_end').val(color);
				updateButtonPreview();
			}
		});

		// Reset to default
		$('#kcm-reset-button-gradient').on('click', function() {
			$('#kcm_button_gradient_start').val('#B11226');
			$('#kcm_button_gradient_start_text').val('#B11226');
			$('#kcm_button_gradient_end').val('#8F0E1E');
			$('#kcm_button_gradient_end_text').val('#8F0E1E');
			updateButtonPreview();
		});
	}

	/**
	 * Update button preview
	 */
	function updateButtonPreview() {
		var startColor = $('#kcm_button_gradient_start').val();
		var endColor = $('#kcm_button_gradient_end').val();
		var gradient = 'linear-gradient(135deg, ' + startColor + ' 0%, ' + endColor + ' 100%)';
		$('#kcm-button-preview').css('background', gradient);
	}

	/**
	 * Email Design Settings - Color Picker Sync
	 */
	function initEmailDesignPicker() {
		// Check if email design elements exist
		if ($('#kcm_email_gradient_start').length === 0) {
			return;
		}

		// Sync color picker with text input
		$('#kcm_email_gradient_start').on('input', function() {
			$('#kcm_email_gradient_start_text').val($(this).val());
			updateEmailPreview();
		});

		$('#kcm_email_gradient_start_text').on('input', function() {
			var color = $(this).val();
			if (/^#[0-9A-Fa-f]{6}$/.test(color)) {
				$('#kcm_email_gradient_start').val(color);
				updateEmailPreview();
			}
		});

		$('#kcm_email_gradient_end').on('input', function() {
			$('#kcm_email_gradient_end_text').val($(this).val());
			updateEmailPreview();
		});

		$('#kcm_email_gradient_end_text').on('input', function() {
			var color = $(this).val();
			if (/^#[0-9A-Fa-f]{6}$/.test(color)) {
				$('#kcm_email_gradient_end').val(color);
				updateEmailPreview();
			}
		});

		// Reset to default
		$('#kcm-reset-gradient').on('click', function() {
			$('#kcm_email_gradient_start').val('#B11226');
			$('#kcm_email_gradient_start_text').val('#B11226');
			$('#kcm_email_gradient_end').val('#8F0E1E');
			$('#kcm_email_gradient_end_text').val('#8F0E1E');
			updateEmailPreview();
		});
	}

	/**
	 * Update email preview
	 */
	function updateEmailPreview() {
		var startColor = $('#kcm_email_gradient_start').val();
		var endColor = $('#kcm_email_gradient_end').val();
		var gradient = 'linear-gradient(135deg, ' + startColor + ' 0%, ' + endColor + ' 100%)';
		$('#kcm-gradient-preview-header').css('background', gradient);
	}

	/**
	 * Document ready
	 */
	$(document).ready(function() {
		initSettings();
		initButtonColoursPicker();
		initEmailDesignPicker();
	});

})(jQuery);
