/**
 * Admin Product Edit Page Scripts
 *
 * Handles conditional display of membership type field based on dojo product checkbox
 *
 * @package Karate_Club_Manager
 * @since 1.0.17
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Get the dojo product checkbox and membership type field
        var $dojoCheckbox = $('#_is_dojo_product');
        var $membershipField = $('#_kcm_membership_type_id').closest('.form-field');

        // Function to toggle membership type field visibility
        function toggleMembershipField() {
            if ($dojoCheckbox.is(':checked')) {
                $membershipField.show();
            } else {
                $membershipField.hide();
                // Optionally reset the field when hidden
                $('#_kcm_membership_type_id').val('');
            }
        }

        // Initial state
        toggleMembershipField();

        // Toggle on checkbox change
        $dojoCheckbox.on('change', function() {
            toggleMembershipField();
        });
    });

})(jQuery);
