/**
 * Admin Instructors Page JavaScript
 *
 * Handles form reveal and field validation
 *
 * @package KarateClubManager
 * @since 1.0.174
 */

jQuery(document).ready(function($) {
	// Show form when clicking Add New button
	$('#kcm-add-instructor-btn, #kcm-add-instructor-btn-empty').on('click', function(e) {
		e.preventDefault();
		$('#kcm-instructor-form').slideDown();
		$('#full_name').focus();
	});

	// Full name validation with visual feedback
	$('#full_name').on('blur', function() {
		var fullName = $(this).val().trim();
		if (!fullName) {
			$(this).css('border-color', '#dc3232');
			if (!$(this).next('.name-error').length) {
				$(this).after('<p class="name-error" style="color: #dc3232; margin-top: 5px;">Full name is required.</p>');
			}
		} else {
			$(this).css('border-color', '');
			$(this).next('.name-error').remove();
		}
	});

	// Clear error on input
	$('#full_name').on('input', function() {
		if ($(this).val().trim()) {
			$(this).css('border-color', '');
			$(this).next('.name-error').remove();
		}
	});

	// Email validation with visual feedback
	$('#instructor_email').on('input', function() {
		var email = $(this).val().trim();
		var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
		if (email && !emailRegex.test(email)) {
			$(this).css('border-color', '#dc3232');
			if (!$(this).next('.email-error').length) {
				$(this).after('<p class="email-error" style="color: #dc3232; margin-top: 5px;">Please enter a valid email address or leave it empty.</p>');
			}
		} else {
			$(this).css('border-color', '');
			$(this).next('.email-error').remove();
		}
	});

	// Phone number validation with visual feedback
	$('#instructor_phone').on('input', function() {
		var phone = $(this).val();
		var isValid = /^[0-9+\-\s\(\)]*$/.test(phone);
		if (phone && !isValid) {
			$(this).css('border-color', '#dc3232');
			if (!$(this).next('.phone-error').length) {
				$(this).after('<p class="phone-error" style="color: #dc3232; margin-top: 5px;">Please use only numbers, spaces, +, -, and parentheses.</p>');
			}
		} else {
			$(this).css('border-color', '');
			$(this).next('.phone-error').remove();
		}
	});

	// Form submit validation
	$('form').on('submit', function(e) {
		var hasError = false;

		// Validate full name (required)
		var fullName = $('#full_name').val().trim();
		if (!fullName) {
			$('#full_name').css('border-color', '#dc3232');
			if (!$('#full_name').next('.name-error').length) {
				$('#full_name').after('<p class="name-error" style="color: #dc3232; margin-top: 5px;">Full name is required.</p>');
			}
			if (!hasError) {
				$('#full_name').focus();
				hasError = true;
			}
		} else {
			$('#full_name').css('border-color', '');
			$('#full_name').next('.name-error').remove();
		}

		// Validate email
		var email = $('#instructor_email').val().trim();
		var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
		if (email && !emailRegex.test(email)) {
			$('#instructor_email').css('border-color', '#dc3232');
			if (!$('#instructor_email').next('.email-error').length) {
				$('#instructor_email').after('<p class="email-error" style="color: #dc3232; margin-top: 5px;">Please enter a valid email address or leave it empty.</p>');
			}
			if (!hasError) {
				$('#instructor_email').focus();
				hasError = true;
			}
		}

		// Validate phone
		var phone = $('#instructor_phone').val();
		if (phone && !/^[0-9+\-\s\(\)]*$/.test(phone)) {
			$('#instructor_phone').css('border-color', '#dc3232');
			if (!$('#instructor_phone').next('.phone-error').length) {
				$('#instructor_phone').after('<p class="phone-error" style="color: #dc3232; margin-top: 5px;">Please use only numbers, spaces, +, -, and parentheses.</p>');
			}
			if (!hasError) {
				$('#instructor_phone').focus();
				hasError = true;
			}
		}

		if (hasError) {
			e.preventDefault();
			return false;
		}
	});
});
