/**
 * Admin Events JavaScript
 *
 * @package Karate_Club_Manager
 * @since 1.0.72
 */

(function($) {
	'use strict';

	$(document).ready(function() {

		// Auto-fill end_date when start_date changes (if end_date is empty)
		$('#start_date').on('change', function() {
			var startDate = $(this).val();
			var $endDate = $('#end_date');

			// Only auto-fill if end_date is empty
			if (startDate && !$endDate.val()) {
				$endDate.val(startDate);
			}
		});

		// Image Upload
		var mediaUploader;

		$('#kcm-upload-image-btn').on('click', function(e) {
			e.preventDefault();

			if (mediaUploader) {
				mediaUploader.open();
				return;
			}

			mediaUploader = wp.media({
				title: 'Select Event Image',
				button: {
					text: 'Use this image'
				},
				multiple: false
			});

			mediaUploader.on('select', function() {
				var attachment = mediaUploader.state().get('selection').first().toJSON();
				$('#image_id').val(attachment.id);
				$('#kcm-image-preview').html('<img src="' + attachment.url + '" alt="">').show();
				$('#kcm-remove-image-btn').show();
			});

			mediaUploader.open();
		});

		$('#kcm-remove-image-btn').on('click', function(e) {
			e.preventDefault();
			$('#image_id').val('');
			$('#kcm-image-preview').html('').hide();
			$(this).hide();
		});

		// Save Event Form
		$('#kcm-event-form').on('submit', function(e) {
			e.preventDefault();

			var $form = $(this);
			var $btn = $('#kcm-save-event-btn');
			var $message = $('#kcm-event-message');

			// Get editor content
			if (typeof tinyMCE !== 'undefined') {
				var editor = tinyMCE.get('description');
				if (editor) {
					editor.save();
				}
			}

			// Disable button
			$btn.prop('disabled', true).text('Saving...');
			$message.hide().removeClass('notice notice-success notice-error');

			// Prepare data
			var formData = $form.serialize();
			formData += '&action=macm_save_event';
			formData += '&nonce=' + macmEvents.nonce;

			// Submit
			$.ajax({
				url: macmEvents.ajaxurl,
				type: 'POST',
				data: formData,
				success: function(response) {
					if (response.success) {
						$message
							.addClass('notice notice-success')
							.html('<p>' + response.data.message + '</p>')
							.show();

						// Redirect to events list after 1 second
						setTimeout(function() {
							window.location.href = 'admin.php?page=kcm-events';
						}, 1000);
					} else {
						$message
							.addClass('notice notice-error')
							.html('<p>' + response.data.message + '</p>')
							.show();
						$btn.prop('disabled', false).text($btn.data('original-text') || 'Save Event');
					}
				},
				error: function() {
					$message
						.addClass('notice notice-error')
						.html('<p>' + macmEvents.strings.error + '</p>')
						.show();
					$btn.prop('disabled', false).text($btn.data('original-text') || 'Save Event');
				}
			});
		});

		// Store original button text
		$('#kcm-save-event-btn').data('original-text', $('#kcm-save-event-btn').text());

		// Delete Event
		$(document).on('click', '.kcm-delete-event', function(e) {
			e.preventDefault();

			if (!confirm(macmEvents.strings.confirmDelete)) {
				return;
			}

			var $link = $(this);
			var eventId = $link.data('event-id');
			var originalText = $link.text();

			$link.css('pointer-events', 'none').text('Deleting...');

			$.ajax({
				url: macmEvents.ajaxurl,
				type: 'POST',
				data: {
					action: 'macm_delete_event',
					nonce: macmEvents.nonce,
					event_id: eventId
				},
				success: function(response) {
					if (response.success) {
						$link.closest('tr').fadeOut(function() {
							$(this).remove();
						});
					} else {
						alert(response.data.message);
						$link.css('pointer-events', 'auto').text(originalText);
					}
				},
				error: function() {
					alert(macmEvents.strings.error);
					$link.css('pointer-events', 'auto').text(originalText);
				}
			});
		});

		// Archive Event
		$(document).on('click', '.kcm-archive-event', function(e) {
			e.preventDefault();

			if (!confirm(macmEvents.strings.confirmArchive)) {
				return;
			}

			var $link = $(this);
			var eventId = $link.data('event-id');
			var originalText = $link.text();

			$link.css('pointer-events', 'none').text('Archiving...');

			$.ajax({
				url: macmEvents.ajaxurl,
				type: 'POST',
				data: {
					action: 'macm_archive_event',
					nonce: macmEvents.nonce,
					event_id: eventId
				},
				success: function(response) {
					if (response.success) {
						location.reload();
					} else {
						alert(response.data.message);
						$link.css('pointer-events', 'auto').text(originalText);
					}
				},
				error: function() {
					alert(macmEvents.strings.error);
					$link.css('pointer-events', 'auto').text(originalText);
				}
			});
		});

		// Unarchive Event
		$(document).on('click', '.kcm-unarchive-event', function(e) {
			e.preventDefault();

			var $link = $(this);
			var eventId = $link.data('event-id');
			var originalText = $link.text();

			$link.css('pointer-events', 'none').text('Unarchiving...');

			$.ajax({
				url: macmEvents.ajaxurl,
				type: 'POST',
				data: {
					action: 'macm_unarchive_event',
					nonce: macmEvents.nonce,
					event_id: eventId
				},
				success: function(response) {
					if (response.success) {
						location.reload();
					} else {
						alert(response.data.message);
						$link.css('pointer-events', 'auto').text(originalText);
					}
				},
				error: function() {
					alert(macmEvents.strings.error);
					$link.css('pointer-events', 'auto').text(originalText);
				}
			});
		});

	});

})(jQuery);
