/**
 * Admin Classes Page JavaScript
 *
 * Handles member selection checkboxes and enrolled members modal
 *
 * @package KarateClubManager
 * @since 1.0.174
 */

jQuery(document).ready(function($) {
	// Select all checkbox in header
	$('#member-select-all').on('change', function() {
		$('.member-checkbox').prop('checked', $(this).prop('checked'));
	});

	// Update header checkbox when individual checkboxes change
	$('.member-checkbox').on('change', function() {
		var total = $('.member-checkbox').length;
		var checked = $('.member-checkbox:checked').length;
		$('#member-select-all').prop('checked', total === checked);
	});

	// Select all button
	$('#select-all-members').on('click', function(e) {
		e.preventDefault();
		$('.member-checkbox').prop('checked', true);
		$('#member-select-all').prop('checked', true);
	});

	// Deselect all button
	$('#deselect-all-members').on('click', function(e) {
		e.preventDefault();
		$('.member-checkbox').prop('checked', false);
		$('#member-select-all').prop('checked', false);
	});

	// View Enrolled Members Modal
	$('#view-enrolled-btn').on('click', function() {
		$('#enrolled-members-modal').fadeIn(200);
		$('body').css('overflow', 'hidden');
	});

	// Close modal
	$('.kcm-modal-close').on('click', function() {
		$('#enrolled-members-modal').fadeOut(200);
		$('body').css('overflow', '');
	});

	// Close modal when clicking overlay
	$('.kcm-modal-overlay').on('click', function(e) {
		if (e.target === this) {
			$('#enrolled-members-modal').fadeOut(200);
			$('body').css('overflow', '');
		}
	});

	// Close modal with ESC key
	$(document).on('keydown', function(e) {
		if (e.key === 'Escape' && $('#enrolled-members-modal').is(':visible')) {
			$('#enrolled-members-modal').fadeOut(200);
			$('body').css('overflow', '');
		}
	});
});
