/**
 * WordPress Markdown Block
 *
 * @package WpGfmRenderer
 */

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import save from './save';
import deprecated from './deprecated';
import metadata from './block.json';

/**
 * Register Markdown block
 */
registerBlockType( metadata.name, {
	title: __( 'Markdown', 'markdown-renderer-for-github' ),
	description: __( 'Write in GitHub Flavored Markdown with real-time preview.', 'markdown-renderer-for-github' ),
	category: 'text',
	icon: {
		src: 'editor-code',
		foreground: '#007cba'
	},
	keywords: [
		__( 'markdown', 'markdown-renderer-for-github' ),
		__( 'gfm', 'markdown-renderer-for-github' ),
		__( 'github', 'markdown-renderer-for-github' ),
		__( 'code', 'markdown-renderer-for-github' )
	],
	// attributes are defined in block.json (includes mermaidBgColor)
	example: {
		attributes: {
			content: '# Heading 1\n\n**Bold** text and *italic* text.\n\n- List item 1\n- List item 2\n\n```javascript\nconst greeting = "Hello, World!";\nconsole.log(greeting);\n```'
		}
	},
	supports: {
		html: false,
		className: true,
		customClassName: true
	},
	edit: Edit,
	save,
	deprecated
} );