<?php
/**
 * Plugin Name: Mara Noia One Page Express Companion Extension
 * Plugin URI: https://maranoia.dk/index.php/one-page-express-companion-extension/
 * Description: Extends the One Page Express Companion plugin
 * Version: 1.2.0
 * Author: Mara Noia
 * Author URI: https://maranoia.dk
 * License: GPLv3 or later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.en.html
 * Text Domain: maranoia-one-page-express-companion-extension
 * Domain Path: /languages
**/

add_action('plugins_loaded', 'maranoia_one_page_express_companion_extension_extend');
add_action('wp_enqueue_scripts', 'maranoia_one_page_express_companion_extension_setup_scripts');
add_action('wp_enqueue_styles', 'maranoia_one_page_express_companion_extension_setup_scripts');
add_action('widgets_init', 'maranoia_one_page_express_companion_extension_widgets_init' );
add_action('wp_ajax_maranoia_one_page_express_companion_extension_shortcode_refresh', 'maranoia_one_page_express_companion_extension_shortcode_refresh' );
add_action('wp_ajax_nopriv_cpe_shortcode_refresh', 'maranoia_one_page_express_companion_extension_shortcode_refresh' );

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function maranoia_one_page_express_companion_extension_extend() {
	// Check that One Page Express Companion plugin is installed and active
	if (!is_plugin_active('one-page-express-companion/one-page-express-companion.php')) {
		add_action('admin_notices', 'maranoia_one_page_express_companion_extension_opec_not_loaded');
	} else {
		// Setup Companion hooks

		// Extend the secionts in the theme customizer
		add_filter('cloudpress\companion\cp_data', 'maranoia_one_page_express_companion_extension_get_maranoia_sections', 11, 2);
		// Handle the widget section content replacement
		add_filter('cloudpress\template\page_content',
			function ( $content ) {
				ob_start();
				dynamic_sidebar('maranoia-one-page-express-widget-section');
				$sidebar = maranoia_one_page_express_companion_extension_ensure_sidebar_text(ob_get_contents());
				ob_end_clean();
				$content = str_replace( '[widgetcontent]', $sidebar, $content );
				return $content;
			}
		);
	}
}

function  maranoia_one_page_express_companion_extension_get_maranoia_sections ( $content, $companion ) {
	$datapath = plugin_dir_path( __FILE__ ) . "assets/data/maranoia-sections.json";
	$sections = (array) maranoia_one_page_express_companion_extension_loadJSON( $datapath );
	foreach ($sections as $section) {
		array_push($content['data']['sections'], $section);
	}
	return $content;
}

function maranoia_one_page_express_companion_extension_setup_scripts() {
	$plugin_data = get_plugin_data( __FILE__ );
	$version = $plugin_data["Version"];
	$js_path = plugins_url( 'assets/js/opec-extender.js', __FILE__ );
	wp_enqueue_script( 'maranoia-one-page-express-companion-extension', $js_path, array(), $version, true );
	$variable_to_js = [
		'ajaxurl' => admin_url('admin-ajax.php'),
		'nonce' => wp_create_nonce('maranoia_one_page_express_companion_extension_shortcode_refresh_nonce')
	];
	wp_localize_script('maranoia-one-page-express-companion-extension', 'maranoia_one_page_express_companion_extension_variables', $variable_to_js);
	$css_path = plugins_url( 'assets/css/styles.css', __FILE__ );
    wp_register_style( 'maranoia-one-page-express-companion-extension', $css_path, array(), $version );
    wp_enqueue_style( 'maranoia-one-page-express-companion-extension' );
}

function maranoia_one_page_express_companion_extension_opec_not_loaded() {
	$message = __('Mara Noia One Page Express Companion Extension: Sorry cannot extend One Page Express Companion because the plugin is not installed and active', 'maranoia-one-page-express-companion-extension');
    printf('<div class="error"><p>%s</p></div>',esc_html($message));
}

function maranoia_one_page_express_companion_extension_loadJSON( $path ) {
	if ( ! file_exists( $path ) ) {
		return array();
	}
	$content = file_get_contents( $path );
	return json_decode( $content, true );
}

// Setup widget "sidebar" to hold the widget content
function maranoia_one_page_express_companion_extension_widgets_init() {
	register_sidebar( array(
		'name'          => 'Mara Noia One Page Express Widget Section',
		'id'            => 'maranoia-one-page-express-widget-section',
		'title'         => "Mara Noia One Page Express Widget Section",
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

}

// Endpoint for JS widget content replacement when adding the section to the page in the admin customizer
function maranoia_one_page_express_companion_extension_shortcode_refresh() {

	// Security
	if (!isset($_POST['nonce']) || !wp_verify_nonce(sanitize_text_field( wp_unslash($_POST['nonce'])), 'maranoia_one_page_express_companion_extension_shortcode_refresh_nonce')) {
		wp_die(-1);
	}

	// Get widget content
	ob_start();
	dynamic_sidebar('maranoia-one-page-express-widget-section');
	$sidebar = maranoia_one_page_express_companion_extension_ensure_sidebar_text(ob_get_contents());
	ob_end_clean();

	// Output content
	echo esc_html($sidebar);
	wp_die();
}

function maranoia_one_page_express_companion_extension_ensure_sidebar_text($sidebar) {
	// Magic empty widget content
	$emptyWidgetContent = "\n<!--dynamic_sidebar_before:one-page-express-widget-section:1-->\n\n<!--dynamic_sidebar_after:one-page-express-widget-section:1-->\n";	

	if((!$sidebar || $sidebar == null || $sidebar == "" || $sidebar == $emptyWidgetContent) && current_user_can('manage_options')) {
		$sidebar ="<div>" . __("Go to widgets administration to add content to the 'One Page Express Widget Section' widget." , 'maranoia-one-page-express-companion-extension') . "</div>";
	}
	return $sidebar;
}
?>