(function (root, CP_Customizer, $) {

	$tickerStartButton = undefined;
	$tickerStopButton = undefined;
	CP_Customizer.overlays.__fixedOverlayOptions.section.items.push(
		{
			'name': 'maranoia-ticker-overlay-menu-item-stop',
			'title': 'Stop ticker', 
			'on_click': function (node) {
				$tickerStartButton.css({'display':'block'});
				$tickerStopButton.css('display', 'none');
				let ticker = node.find('.maranoia-ticker');
				ticker.css({'transform': 'translate3d(-50%, 0, 0) !important'});
				ticker.css({'animation-play-state': 'paused'});
			}
		},
		{
			'name': 'maranoia-ticker-overlay-menu-item-start',
			'title': 'Start ticker', 
			'on_click': function (node) {
				$tickerStartButton.css({'display':'none'});
				$tickerStopButton.css('display', 'block');
				let ticker = node.find('.maranoia-ticker');
				ticker.css({'transform': 'translate3d(-100%, 0, 0) !important'});
				ticker.css({'animation-play-state': 'running'});
			}
		}
	);
	
	// Set up for observers in the customizer admin
	setupObservers();

	function setupObservers() {
		var isWidgetObserverActive = false;
		var widgetObserver = new MutationObserver(function (mutations) {
			$node = $("#maranoia-3")[0];
			if ($node != undefined) {
				updateWidgetShortCode("widgetcontent", $("#maranoia-3 > .maranoia-widget-area-content"));
				widgetObserver.disconnect();
				isWidgetObserverActive = false;
			}
		});

		var observerObserver = new MutationObserver(function (mutations) {
			$node = $("#maranoia-3")[0];
			if ($node === undefined && !isWidgetObserverActive) {
				widgetObserver.observe(document, { attributes: false, childList: true, characterData: false, subtree: true });
				isWidgetObserverActive = true;
			}
		});

		var maranoiaObserver = new MutationObserver(function (mutations) {
			$nodes = $('.maranoia-overlay[data-category^="maranoia-"]');
			
			if ($nodes !== undefined && $nodes.length > 0) {
				var overlaysContainer = $('#cp-overlays');
				if(overlaysContainer !== undefined && overlaysContainer.length > 0){

					var panels = overlaysContainer.find('div.options-group');
					panels.each(function(index, item) {
						var sectionTitle =  $(item).find('.cog-item.title[data-category="section"');
						switch(sectionTitle[0].innerText) {
							case "ticker [Section]":
								$tickerStartButton = $(item).find('[data-name="maranoia-ticker-overlay-menu-item-start"');
								$tickerStopButton = $(item).find('[data-name="maranoia-ticker-overlay-menu-item-stop"');
								if ($tickerStopButton.css("display") !== "none" ) {
									$tickerStartButton.css("display", "none");
								}
								break;
							case "widget [Section]":
								$(item).find('[data-name^="maranoia-ticker-overlay-menu-item-"').remove();
								break;
						}
					});
				}
			}
		});

		maranoiaObserver.observe(document, { attributes: false, childList: true, characterData: false, subtree: true });
		observerObserver.observe(document, { attributes: false, childList: true, characterData: false, subtree: true });
	}

	// Endpoint to get the widget content from frontend
	function updateWidgetShortCode(shortcode, $node) {
		if(CP_Customizer === undefined) return;
		CP_Customizer.preview.pauseObserver();
		CP_Customizer.preview.blur();
		var data = {
			action: 'maranoia_one_page_express_companion_extension_shortcode_refresh',
			shortcode: btoa(shortcode),
			nonce: maranoia_one_page_express_companion_extension_variables.nonce,
			_: Date.now()
		};

		jQuery.ajax({
			url: maranoia_one_page_express_companion_extension_variables.ajaxurl,
			method: 'POST',
			data: data
		}).done(function (response) {
			$node.empty();
			$node.html(_.unescape(response));

			CP_Customizer.hideLoader();
			CP_Customizer.preview.decorateMods($node);
			CP_Customizer.preview.decorateElements($node);

			_.delay(function () {
				CP_Customizer.hooks.doAction("shortcode_updated", $node, shortcode);
				CP_Customizer.updateState();
			}, 0);
		})
		
	}
})(window, this.parent.window.CP_Customizer, jQuery);