/**
 * MameTech Chat Button - Multiple Numbers Management Scripts
 */
jQuery(document).ready(function($) {
    // Abilita sortable sulla tabella numeri
    $('#sortable-numbers').sortable({
        handle: '.handle',
        axis: 'y',
        update: function(event, ui) {
            var order = [];
            $('#sortable-numbers tr').each(function(index) {
                order.push($(this).data('id'));
            });
            
            $.ajax({
                url: mametechCbAjax.ajax_url,
                type: 'POST',
                data: {
                    action: 'mametech_cb_save_numbers',
                    nonce: mametechCbAjax.nonce,
                    order: order
                }
            });
        }
    });
    
    // Gestione eliminazione numero
    $('.delete-number').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm('Sei sicuro di voler eliminare questo numero?')) {
            return;
        }
        
        var button = $(this);
        var numberId = button.data('id');
        
        $.ajax({
            url: mametechCbAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'mametech_cb_delete_number',
                nonce: mametechCbAjax.nonce,
                number_id: numberId
            },
            success: function(response) {
                if (response.success) {
                    button.closest('tr').fadeOut(300, function() {
                        $(this).remove();
                    });
                } else {
                    alert('Errore durante l\'eliminazione');
                }
            }
        });
    });
});
