/**
 * WhatsApp Floating Button PRO - Frontend JavaScript con Numeri Multipli
 * Gestisce il tracking dei click e la selezione numeri multipli
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // Track clicks sul pulsante WhatsApp
        $('.wfb-floating-button a, .wfb-shortcode-button, .wfb-widget-button').on('click', function(e) {
            
            // Se le statistiche sono disabilitate, non tracciare
            if (typeof mametechCbData === 'undefined' || mametechCbData.enable_stats !== '1') {
                return;
            }
            
            var buttonId = $(this).closest('.wfb-floating-button').data('button-id') || 'shortcode';
            var pageUrl = window.location.href;
            
            // Invia il tracciamento via AJAX (non bloccante)
            $.ajax({
                url: mametechCbData.ajax_url,
                type: 'POST',
                data: {
                    action: 'mametech_cb_track_click',
                    nonce: mametechCbData.nonce,
                    button_id: buttonId,
                    page_url: pageUrl
                },
                async: true,
                timeout: 2000
            });
        });
        
        // Gestione Numeri Multipli
        if (typeof mametechCbData !== 'undefined' && mametechCbData.multiple_numbers && mametechCbData.multiple_numbers.length > 0) {
            
            // Intercetta il click sul pulsante principale
            $('.wfb-floating-button a').on('click', function(e) {
                e.preventDefault();
                
                // Mostra il menu di selezione
                showNumbersMenu();
                
                return false;
            });
        }
        
        // Animazione di entrata del pulsante
        setTimeout(function() {
            $('.wfb-floating-button').addClass('wfb-show');
        }, 500);
        
        /**
         * Mostra il menu per selezionare il numero
         */
        function showNumbersMenu() {
            // Rimuovi menu esistente se presente
            $('.wfb-numbers-menu').remove();
            
            var numbers = mametechCbData.multiple_numbers;
            var position = mametechCbData.button_position || 'bottom-right';
            
            // Crea il menu HTML
            var menuHtml = '<div class="wfb-numbers-menu wfb-menu-' + position + '">';
            menuHtml += '<div class="wfb-menu-header">';
            menuHtml += '<span class="wfb-menu-title">' + escapeHtml(mametechCbData.multiple_menu_text || 'Scegli con chi parlare') + '</span>';
            menuHtml += '<button class="wfb-menu-close" aria-label="Chiudi">&times;</button>';
            menuHtml += '</div>';
            menuHtml += '<div class="wfb-menu-body">';
            
            // Aggiungi ogni numero
            $.each(numbers, function(index, number) {
                menuHtml += '<a href="#" class="wfb-number-item" data-phone="' + escapeHtml(number.phone) + '" data-message="' + escapeHtml(number.message) + '" data-id="' + index + '">';
                menuHtml += '<div class="wfb-number-icon">';
                menuHtml += '<svg viewBox="0 0 32 32"><path fill="currentColor" d="M16 0C7.164 0 0 7.164 0 16c0 2.829.747 5.482 2.051 7.792L.051 31.95l8.367-2.174A15.936 15.936 0 0016 32c8.836 0 16-7.164 16-16S24.836 0 16 0zm0 29.333c-2.453 0-4.789-.667-6.832-1.899l-.491-.293-5.109 1.328 1.328-5.109-.293-.491A13.268 13.268 0 012.667 16C2.667 8.636 8.636 2.667 16 2.667S29.333 8.636 29.333 16 23.364 29.333 16 29.333zm7.448-9.781c-.405-.203-2.4-1.184-2.773-1.32-.373-.136-.645-.203-.917.203-.272.405-1.053 1.32-1.291 1.593-.237.272-.475.305-.88.102-.405-.203-1.709-.629-3.255-2.008-1.203-1.072-2.016-2.396-2.253-2.801-.237-.405-.025-.624.177-.826.183-.183.405-.475.608-.713.203-.237.271-.405.407-.677.136-.272.068-.509-.034-.713-.102-.203-.917-2.208-1.256-3.025-.331-.797-.667-.688-.917-.701-.237-.013-.509-.017-.781-.017s-.713.102-1.087.509c-.373.405-1.423 1.391-1.423 3.396s1.457 3.937 1.66 4.209c.203.272 2.859 4.365 6.927 6.119.968.417 1.724.667 2.312.853.972.309 1.856.265 2.555.161.78-.116 2.4-.981 2.737-1.928.337-.947.337-1.759.237-1.928-.102-.169-.373-.272-.78-.475z"/></svg>';
                menuHtml += '</div>';
                menuHtml += '<div class="wfb-number-info">';
                menuHtml += '<div class="wfb-number-name">' + escapeHtml(number.name) + '</div>';
                if (number.department) {
                    menuHtml += '<div class="wfb-number-department">' + escapeHtml(number.department) + '</div>';
                }
                menuHtml += '</div>';
                menuHtml += '<div class="wfb-number-arrow">→</div>';
                menuHtml += '</a>';
            });
            
            menuHtml += '</div>';
            menuHtml += '</div>';
            
            // Aggiungi overlay
            var overlayHtml = '<div class="wfb-menu-overlay"></div>';
            
            // Inserisci nel DOM
            $('body').append(overlayHtml + menuHtml);
            
            // Animazione entrata
            setTimeout(function() {
                $('.wfb-menu-overlay').addClass('wfb-show');
                $('.wfb-numbers-menu').addClass('wfb-show');
            }, 10);
            
            // Event handlers
            bindMenuEvents();
        }
        
        /**
         * Collega gli eventi del menu
         */
        function bindMenuEvents() {
            // Click su un numero
            $('.wfb-number-item').on('click', function(e) {
                e.preventDefault();
                
                var phone = $(this).data('phone');
                var message = $(this).data('message') || mametechCbData.default_message || '';
                var numberId = $(this).data('id');
                
                // Traccia la selezione
                if (mametechCbData.enable_stats === '1') {
                    trackNumberSelection(numberId);
                }
                
                // Crea URL WhatsApp
                var whatsappUrl = 'https://wa.me/' + phone;
                if (message) {
                    whatsappUrl += '?text=' + encodeURIComponent(message);
                }
                
                // Chiudi il menu
                closeNumbersMenu();
                
                // Apri WhatsApp
                window.open(whatsappUrl, '_blank', 'noopener,noreferrer');
            });
            
            // Chiudi con X
            $('.wfb-menu-close').on('click', function(e) {
                e.preventDefault();
                closeNumbersMenu();
            });
            
            // Chiudi con overlay
            $('.wfb-menu-overlay').on('click', function() {
                closeNumbersMenu();
            });
            
            // Chiudi con ESC
            $(document).on('keydown.wfbmenu', function(e) {
                if (e.key === 'Escape') {
                    closeNumbersMenu();
                }
            });
        }
        
        /**
         * Chiudi il menu
         */
        function closeNumbersMenu() {
            $('.wfb-menu-overlay').removeClass('wfb-show');
            $('.wfb-numbers-menu').removeClass('wfb-show');
            
            setTimeout(function() {
                $('.wfb-menu-overlay').remove();
                $('.wfb-numbers-menu').remove();
                $(document).off('keydown.wfbmenu');
            }, 300);
        }
        
        /**
         * Traccia la selezione del numero
         */
        function trackNumberSelection(numberId) {
            $.ajax({
                url: mametechCbData.ajax_url,
                type: 'POST',
                data: {
                    action: 'mametech_cb_track_click',
                    nonce: mametechCbData.nonce,
                    button_id: 'multiple_' + numberId,
                    page_url: window.location.href
                },
                async: true,
                timeout: 2000
            });
        }
        
        /**
         * Escape HTML per sicurezza
         */
        function escapeHtml(text) {
            if (!text) return '';
            var map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#039;'
            };
            return text.replace(/[&<>"']/g, function(m) { return map[m]; });
        }
        
    });
    
})(jQuery);
