/**
 * MameTech Chat Button - Admin Scripts
 */
jQuery(document).ready(function($) {
    // Gestione tabs
    $('.wfb-tab-button').on('click', function() {
        var tab = $(this).data('tab');
        $('.wfb-tab-button').removeClass('active');
        $(this).addClass('active');
        $('.wfb-tab-content').removeClass('active');
        $('#tab-' + tab).addClass('active');
    });
    
    // Mostra/nascondi impostazioni orari
    $('#mametech_cb_schedule_enabled').on('change', function() {
        $('#schedule-settings').toggle(this.checked);
    });
    
    // Aggiorna valore dimensione
    $('#mametech_cb_button_size').on('input', function() {
        $('#size-value').text($(this).val() + 'px');
        updatePreview();
    });
    
    // Aggiorna anteprima
    function updatePreview() {
        var position = $('#mametech_cb_position').val();
        var size = $('#mametech_cb_button_size').val() || 60;
        var theme = $('#mametech_cb_theme').val() || 'default';
        var preview = $('#wfb-preview-button');
        
        preview.css({
            'width': size + 'px',
            'height': size + 'px',
            'padding': (size * 0.2) + 'px'
        });
        
        // Reset position
        preview.css({
            'top': 'auto',
            'bottom': 'auto',
            'left': 'auto',
            'right': 'auto'
        });
        
        // Set position
        switch(position) {
            case 'bottom-right':
                preview.css({'bottom': '20px', 'right': '20px'});
                break;
            case 'bottom-left':
                preview.css({'bottom': '20px', 'left': '20px'});
                break;
            case 'top-right':
                preview.css({'top': '20px', 'right': '20px'});
                break;
            case 'top-left':
                preview.css({'top': '20px', 'left': '20px'});
                break;
        }
        
        // Apply theme
        applyTheme(preview, theme);
    }
    
    function applyTheme(element, theme) {
        element.removeClass('theme-minimal theme-gradient theme-pulse theme-dark');
        
        switch(theme) {
            case 'minimal':
                element.css('background', '#fff');
                element.css('border', '2px solid #25D366');
                break;
            case 'gradient':
                element.css('background', 'linear-gradient(135deg, #25D366 0%, #128C7E 100%)');
                element.css('border', 'none');
                break;
            case 'pulse':
                element.css('background', '#25D366');
                element.addClass('theme-pulse');
                break;
            case 'dark':
                element.css('background', '#128C7E');
                element.css('border', 'none');
                break;
            default:
                element.css('background', '#25D366');
                element.css('border', 'none');
        }
    }
    
    // Inizializza anteprima
    $('#mametech_cb_position, #mametech_cb_theme').on('change', updatePreview);
    updatePreview();
});
