<?php
/**
 * Plugin Name: Makuruwan Arithmetic Human Quiz
 * Description: Adds a lightweight arithmetic challenge (no reCAPTCHA) to block bots on login and any custom form using a shortcode.
 * Version: 1.0.2
 * Author: Cletous Ngoma
 * Author URI: https://mws.makuruwan.com
 * License: GPL-2.0+
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * Text Domain: makuruwan-arithmetic-human-quiz
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load main plugin class.
require_once plugin_dir_path(__FILE__) . 'includes/class-makarhq-plugin.php';

// Helper template tag for shortcode errors on custom forms.
function makarhq_last_error_message()
{
    $key = MAKARHQ_Plugin::instance()->client_key();
    $err = get_transient('makarhq_last_error_' . $key);
    if ($err) {
        echo '<div class="makarhq-error" role="alert" style="margin:10px 0;color:#b32d2e">' . esc_html($err) . '</div>';
    }
}

/** Plugin row meta: add author link */
add_filter(
    'plugin_row_meta',
    function ($links, $file) {
        if ($file === plugin_basename(__FILE__)) {
            $url = esc_url('https://mws.makuruwan.com');
            $text = esc_html('Get Dedicated Hosting');
            $links[] = '<a href="' . $url . '" target="_blank" rel="noopener">' . $text . '</a>';
        }
        return $links;
    },
    10,
    2
);

// Boot the plugin.
MAKARHQ_Plugin::instance();
