<?php
/*
 * Plugin Name: MakeMyBrand
 * Plugin URI: https://makemybrand.ai/
 * Description: Adds an infographic to new posts
 * Version: 1.03
 * Author: Make My Brand
 * Author URI: https://makemybrand.ai
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright (C) 2024 MakeMyBrand.AI
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
?>

<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

add_action('init', 'makemybrand_register_blocks');

function makemybrand_register_blocks() {
    if (!function_exists('register_block_type')) {
        return;
    }
    register_block_type('makemybrand/infographic', array(
        'editor_script' => 'makemybrand-editor', # should be enqueued
        'render_callback' => 'makemybrand_render_infographic',
        'attributes' => array(
            'imageUrl' => array(
                'type' => 'string',
                'default' => '',
            ),
            'designId' => array(
                'type' => 'string',
                'default' => '',
            ),
        ),
    ));
}

function makemybrand_render_infographic($attributes) {
    $image_url = esc_url($attributes['imageUrl']);
    $design_id = esc_attr($attributes['designId']);
    
    ob_start();
    ?>
    <div class="makemybrand-infographic">
        <img src="<?php echo esc_url($image_url); ?>" alt="Infographic" />
    </div>
    <?php
    return ob_get_clean();
}