<?php
/*
 * Plugin Name: MakeMyBrand
 * Plugin URI: https://makemybrand.ai/
 * Description: Adds an infographic to new posts
 * Version: 1.03
 * Author: Make My Brand
 * Author URI: https://makemybrand.ai
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright (C) 2024 MakeMyBrand.AI
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
?>

<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function makemybrand_enqueue_scripts($hook) { 
    ini_set('log_errors', 1);
    ini_set('error_log', '/opt/homebrew/var/log/php_error.log');
    error_log('enqueue_block_editor_assets triggered!');
    error_log($hook);
    

    wp_enqueue_script('react', plugin_dir_url(__FILE__) . '../lib/react.production.min.js', array(), "17.0.2", true);
    wp_enqueue_script('react-dom', plugin_dir_url(__FILE__) . '../lib/react-dom.production.min.js', array('react'), "17.0.2", true);

    wp_enqueue_script('wp-i18n');
    wp_enqueue_script('wp-components');
    wp_enqueue_script('wp-api-fetch');

    wp_enqueue_script(
        'makemybrand-main',
        plugin_dir_url(__FILE__) . '../assets/main.bundle.js',
        array('jquery', 'react', 'react-dom', 'wp-i18n', 'wp-data', 'wp-edit-post', 'wp-element', 'wp-components', 'wp-blocks', 'wp-editor'), // Dependencies
        filemtime(plugin_dir_path(__FILE__) . '../assets/main.bundle.js'), // Use file modification time as version
        true
    );

    wp_enqueue_script(
        'makemybrand-editor',
        plugin_dir_url(__FILE__) . '../assets/makemybrand-block-editor.js',
        array('wp-blocks',
            'wp-dom-ready',
            'wp-element', 'wp-editor', 'wp-components', 'wp-i18n', 'wp-api-fetch'), // Dependencies
        filemtime(plugin_dir_path(__FILE__) . '../assets/makemybrand-block-editor.js'), // Use file modification time as version
        true
    );
    
    wp_localize_script('makemybrand-main', 'makemybrand', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'user_token' => get_option('makemybrand_user_authtoken'),
        'post_id' => get_the_ID(),
        'post_title' => get_the_title(),

        'fetch_userinfo_nonce' => wp_create_nonce('makemybrand_fetch_userinfo_nonce'),
        'add_infographic_nonce' => wp_create_nonce('makemybrand_add_infographic_nonce'),
        'update_token_nonce' => wp_create_nonce('makemybrand_update_token_nonce'),

    ));

    
}

add_action('enqueue_block_editor_assets', 'makemybrand_enqueue_scripts');

function makemybrand_my_react_plugin_render() {
    echo '<div id="my-react-root"></div>';
}

add_action('admin_footer', 'makemybrand_my_react_plugin_render');

// add_action('enqueue_block_editor_assets', function () {
//     // Add your script enqueues here
// });