document.addEventListener('DOMContentLoaded', function() {
    const apiKey = Mailsoftly.apiKey;;

    if (apiKey) {
        fetch('https://app.mailsoftly.com/forms_meta_data?api_key=' + encodeURIComponent(apiKey))
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            const formsList = document.getElementById('forms-list');
            formsList.innerHTML = ''; // Eski içerikleri temizle

            if (data.length === 0) {
                formsList.innerHTML = '<tr><td colspan="3">No forms found. Please click <a href="https://app.mailsoftly.com/soft_forms">here</a> to create one.</td></tr>';
            } else {
                data.forEach(form => {

                    if (!form.id) {
                        return; // Eğer id veya name yoksa işlemeden geç
                    }
                    const formId = form.id; 
                    const shortcode = `[mailsoftly_form id="${formId}"]`; 

                    console.log(form);

                    const formName = form.name ? form.name : 'Unnamed Form';

                    formsList.innerHTML += 
                        `<tr style="border-bottom: 1px solid gray;">
                            <td>${formName}</td>
                            <td><code>${shortcode}</code></td>
                            <td>
                                <button class="button button-primary use-this-form" data-form-code='${shortcode}'>Use</button>
                                <button class="button button-secondary preview-form" data-form-id='${formId}'>Preview</button>
                            </td>
                        </tr>`;
                });

                document.querySelectorAll('.use-this-form').forEach(button => {
                    button.addEventListener('click', function() {
                        const formCode = this.getAttribute('data-form-code');
                        document.getElementById('form-code').value = formCode;
                        document.getElementById('form-modal').style.display = 'block';
                        document.getElementById('form-modal-overlay').style.display = 'block';
                    });
                });

                // Preview butonunu ele al
document.querySelectorAll('.preview-form').forEach(button => {
    button.addEventListener('click', function() {
        const formId = this.getAttribute('data-form-id');
        fetch(`https://app.mailsoftly.com/form_data?api_key=${encodeURIComponent(apiKey)}&form_id=${formId}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            console.log(data);
            const formModalContent = document.getElementById('form-modal-content');
            formModalContent.innerHTML = `
                <h2>Preview of "${data.name}"</h2>
                <div class="form_body"><iframe width='400' height='400' style='border:none;' src='https://app.mailsoftly.com/soft_forms/${data.id}'></iframe></div>
                <button id="close-modal" class="button button-secondary" style="margin-top:10px;">Close</button>
            `;


            document.getElementsByClassName('form_body').innerHTML = data.form_data;
            document.getElementById('form-modal').style.display = 'block';
            document.getElementById('form-modal-overlay').style.display = 'block';

            // Close modal event
            document.getElementById('close-modal').addEventListener('click', function() {
                document.getElementById('form-modal').style.display = 'none';
                document.getElementById('form-modal-overlay').style.display = 'none';
            });
        })
        .catch(error => {
            console.error('Fetch error:', error);
            alert('Error fetching form data.');
        });
    });
});




                document.getElementById('close-modal').addEventListener('click', function() {
                    document.getElementById('form-modal').style.display = 'none';
                    document.getElementById('form-modal-overlay').style.display = 'none';
                });

                document.getElementById('form-modal-overlay').addEventListener('click', function() {
                    document.getElementById('form-modal').style.display = 'none';
                    document.getElementById('form-modal-overlay').style.display = 'none';
                });
            }
        })
        .catch(error => {
            console.error('Fetch error:', error);
        });
    }
});
