<?php
declare (strict_types=1);
namespace MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection;
if (!defined('ABSPATH')) exit;
use MailPoetVendor\Doctrine\ORM\Cache\CollectionCacheKey;
use MailPoetVendor\Doctrine\ORM\PersistentCollection;
use function spl_object_id;
class NonStrictReadWriteCachedCollectionPersister extends AbstractCollectionPersister
{
 public function afterTransactionComplete()
 {
 if (isset($this->queuedCache['update'])) {
 foreach ($this->queuedCache['update'] as $item) {
 $this->storeCollectionCache($item['key'], $item['list']);
 }
 }
 if (isset($this->queuedCache['delete'])) {
 foreach ($this->queuedCache['delete'] as $key) {
 $this->region->evict($key);
 }
 }
 $this->queuedCache = [];
 }
 public function afterTransactionRolledBack()
 {
 $this->queuedCache = [];
 }
 public function delete(PersistentCollection $collection)
 {
 $ownerId = $this->uow->getEntityIdentifier($collection->getOwner());
 $key = new CollectionCacheKey($this->sourceEntity->rootEntityName, $this->association['fieldName'], $ownerId, $this->filters->getHash());
 $this->persister->delete($collection);
 $this->queuedCache['delete'][spl_object_id($collection)] = $key;
 }
 public function update(PersistentCollection $collection)
 {
 $isInitialized = $collection->isInitialized();
 $isDirty = $collection->isDirty();
 if (!$isInitialized && !$isDirty) {
 return;
 }
 $ownerId = $this->uow->getEntityIdentifier($collection->getOwner());
 $key = new CollectionCacheKey($this->sourceEntity->rootEntityName, $this->association['fieldName'], $ownerId, $this->filters->getHash());
 // Invalidate non initialized collections OR ordered collection
 if ($isDirty && !$isInitialized || isset($this->association['orderBy'])) {
 $this->persister->update($collection);
 $this->queuedCache['delete'][spl_object_id($collection)] = $key;
 return;
 }
 $this->persister->update($collection);
 $this->queuedCache['update'][spl_object_id($collection)] = ['key' => $key, 'list' => $collection];
 }
}
