<?php
/**
 * Uninstall script for MailMoo Mailgun plugin
 * 
 * This file is executed when the plugin is uninstalled.
 * It removes all plugin data including settings and email logs.
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
$options_to_delete = array(
    'mailmoo_for_mailgun_api_key',
    'mailmoo_for_mailgun_domain',
    'mailmoo_for_mailgun_from_email',
    'mailmoo_for_mailgun_from_name',
    'mailmoo_for_mailgun_reply_to_email',
    'mailmoo_for_mailgun_reply_to_name',
    'mailmoo_for_mailgun_enable_logging'
);

foreach ($options_to_delete as $option) {
    delete_option($option);
}

// Drop the email logs table
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
$wpdb->query("DROP TABLE IF EXISTS `{$wpdb->prefix}mailmoo_for_mailgun_email_logs`");

// Clear any cached data
wp_cache_flush();