<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Handle log deletion
if (isset($_POST['delete_logs']) && check_admin_referer('mailmoo_for_mailgun_delete_logs_nonce')) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mailmoo_for_mailgun_email_logs';
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query("TRUNCATE TABLE `{$wpdb->prefix}mailmoo_for_mailgun_email_logs`");
    echo '<div class="notice notice-success"><p>' . esc_html__('Email logs cleared successfully!', 'mailmoo-for-mailgun') . '</p></div>';
}

// Handle single log deletion
if (isset($_GET['delete_log'])) {
    $delete_log_id = sanitize_text_field(wp_unslash($_GET['delete_log']));
    if (check_admin_referer('mailmoo_for_mailgun_delete_log_' . $delete_log_id)) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'mailmoo_for_mailgun_email_logs';
        $log_id = intval($delete_log_id);
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->delete($table_name, array('id' => $log_id), array('%d'));
        echo '<div class="notice notice-success"><p>' . esc_html__('Email log deleted successfully!', 'mailmoo-for-mailgun') . '</p></div>';
    }
}

// Pagination
$per_page = 20;
$current_page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$offset = ($current_page - 1) * $per_page;

// Get logs
global $wpdb;
$table_name = $wpdb->prefix . 'mailmoo_for_mailgun_email_logs';

// Count total logs
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$total_logs = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}mailmoo_for_mailgun_email_logs`");
$total_pages = ceil($total_logs / $per_page);

// Get logs for current page
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$logs = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM `{$wpdb->prefix}mailmoo_for_mailgun_email_logs` ORDER BY timestamp DESC LIMIT %d OFFSET %d",
    $per_page,
    $offset
));
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="tablenav top">
        <div class="alignleft actions">
            <form method="post" action="" onsubmit="return confirm('<?php esc_html_e('Are you sure you want to delete all email logs?', 'mailmoo-for-mailgun'); ?>');">
                <?php wp_nonce_field('mailmoo_for_mailgun_delete_logs_nonce'); ?>
                <?php submit_button(__('Clear All Logs', 'mailmoo-for-mailgun'), 'delete', 'delete_logs', false); ?>
            </form>
        </div>
        
        <div class="alignright">
            <span class="displaying-num">
                <?php 
                /* translators: %s: number of email logs */
                printf(esc_html__('%s logs', 'mailmoo-for-mailgun'), esc_html(number_format_i18n($total_logs))); ?>
            </span>
        </div>
        
        <div class="tablenav-pages">
            <?php
            $pagination_args = array(
                'base' => add_query_arg('paged', '%#%'),
                'format' => '',
                'prev_text' => __('&laquo;', 'mailmoo-for-mailgun'),
                'next_text' => __('&raquo;', 'mailmoo-for-mailgun'),
                'total' => $total_pages,
                'current' => $current_page
            );
            echo wp_kses_post(paginate_links($pagination_args));
            ?>
        </div>
    </div>
    
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th scope="col" class="manage-column column-date"><?php esc_html_e('Date', 'mailmoo-for-mailgun'); ?></th>
                <th scope="col" class="manage-column column-to"><?php esc_html_e('To', 'mailmoo-for-mailgun'); ?></th>
                <th scope="col" class="manage-column column-subject"><?php esc_html_e('Subject', 'mailmoo-for-mailgun'); ?></th>
                <th scope="col" class="manage-column column-status"><?php esc_html_e('Status', 'mailmoo-for-mailgun'); ?></th>
                <th scope="col" class="manage-column column-message-id"><?php esc_html_e('Message ID', 'mailmoo-for-mailgun'); ?></th>
                <th scope="col" class="manage-column column-actions"><?php esc_html_e('Actions', 'mailmoo-for-mailgun'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($logs)): ?>
                <tr>
                    <td colspan="6" class="no-items"><?php esc_html_e('No email logs found.', 'mailmoo-for-mailgun'); ?></td>
                </tr>
            <?php else: ?>
                <?php foreach ($logs as $log): ?>
                    <tr>
                        <td class="column-date">
                            <?php echo esc_html(gmdate('Y-m-d H:i:s', strtotime($log->timestamp))); ?>
                        </td>
                        <td class="column-to">
                            <?php echo esc_html($log->to_email); ?>
                        </td>
                        <td class="column-subject">
                            <?php echo esc_html($log->subject); ?>
                        </td>
                        <td class="column-status">
                            <?php if ($log->status === 'sent'): ?>
                                <span class="status-success">✓ <?php esc_html_e('Sent', 'mailmoo-for-mailgun'); ?></span>
                            <?php else: ?>
                                <span class="status-error">✗ <?php esc_html_e('Failed', 'mailmoo-for-mailgun'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="column-message-id">
                            <?php if (!empty($log->mailgun_message_id)): ?>
                                <code><?php echo esc_html(substr($log->mailgun_message_id, 0, 20)); ?>...</code>
                            <?php else: ?>
                                <span class="description"><?php esc_html_e('N/A', 'mailmoo-for-mailgun'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="column-actions">
                            <a href="#" class="view-log" data-log-id="<?php echo esc_attr($log->id); ?>"><?php esc_html_e('View', 'mailmoo-for-mailgun'); ?></a>
                            |
                            <a href="<?php echo esc_url(wp_nonce_url(add_query_arg('delete_log', $log->id), 'mailmoo_for_mailgun_delete_log_' . $log->id)); ?>" 
                               class="delete" 
                               onclick="return confirm('<?php esc_html_e('Are you sure you want to delete this log?', 'mailmoo-for-mailgun'); ?>');">
                                <?php esc_html_e('Delete', 'mailmoo-for-mailgun'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="tablenav bottom">
        <div class="tablenav-pages">
            <?php echo wp_kses_post(paginate_links($pagination_args)); ?>
        </div>
    </div>
</div>

<!-- Modal for viewing log details -->
<div id="log-modal" class="mailmoo-for-mailgun-modal" style="display: none;">
    <div class="mailmoo-for-mailgun-modal-content">
        <div class="mailmoo-for-mailgun-modal-header">
            <h2><?php esc_html_e('Email Log Details', 'mailmoo-for-mailgun'); ?></h2>
            <span class="mailmoo-for-mailgun-close">&times;</span>
        </div>
        <div class="mailmoo-for-mailgun-modal-body">
            <div id="log-details"></div>
        </div>
    </div>
</div>