<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Handle form submission
if (isset($_POST['submit']) && check_admin_referer('mailmoo_for_mailgun_settings_nonce')) {
    $options = array(
        'mailmoo_for_mailgun_api_key',
        'mailmoo_for_mailgun_domain',
        'mailmoo_for_mailgun_from_email',
        'mailmoo_for_mailgun_from_name',
        'mailmoo_for_mailgun_reply_to_email',
        'mailmoo_for_mailgun_reply_to_name',
        'mailmoo_for_mailgun_enable_logging'
    );
    
    foreach ($options as $option) {
        if (isset($_POST[$option])) {
            update_option($option, sanitize_text_field(wp_unslash($_POST[$option])));
        }
    }
    
    echo '<div class="notice notice-success"><p>' . esc_html__('Settings saved successfully!', 'mailmoo-for-mailgun') . '</p></div>';
}

// Handle test email
if (isset($_POST['send_test']) && check_admin_referer('mailmoo_for_mailgun_test_nonce')) {
    // Check if test_email exists, then unslash and sanitize
    if (isset($_POST['test_email'])) {
        $test_email = sanitize_email(wp_unslash($_POST['test_email']));
        if (!empty($test_email)) {
            $subject = __('MailMoo Mailgun Test Email', 'mailmoo-for-mailgun');
            $message = __('This is a test email sent from MailMoo Mailgun plugin.', 'mailmoo-for-mailgun');
            
            if (wp_mail($test_email, $subject, $message)) {
                echo '<div class="notice notice-success"><p>' . esc_html__('Test email sent successfully!', 'mailmoo-for-mailgun') . '</p></div>';
            } else {
                echo '<div class="notice notice-error"><p>' . esc_html__('Test email failed to send.', 'mailmoo-for-mailgun') . '</p></div>';
            }
        }
    }
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    
    <form method="post" action="">
        <?php wp_nonce_field('mailmoo_for_mailgun_settings_nonce'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e('Mailgun API Key', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="password" name="mailmoo_for_mailgun_api_key" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_api_key')); ?>" class="regular-text" />
                    <p class="description">
                        <?php esc_html_e('Enter your Mailgun API key (Private API key). You can find it in your Mailgun dashboard at:', 'mailmoo-for-mailgun'); ?>
                        <a href="https://app.mailgun.com/app/account/security/api_keys" target="_blank">Mailgun API Keys</a>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Mailgun Domain', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="text" name="mailmoo_for_mailgun_domain" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_domain')); ?>" class="regular-text" placeholder="mg.yourdomain.com" />
                    <p class="description">
                        <?php esc_html_e('Enter your Mailgun domain. You can find it in your Mailgun dashboard at:', 'mailmoo-for-mailgun'); ?>
                        <a href="https://app.mailgun.com/app/domains" target="_blank">Mailgun Domains</a>
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('From Email', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="email" name="mailmoo_for_mailgun_from_email" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_from_email')); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('This email address must be from your verified domain', 'mailmoo-for-mailgun'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('From Name', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="text" name="mailmoo_for_mailgun_from_name" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_from_name')); ?>" class="regular-text" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Reply-To Email', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="email" name="mailmoo_for_mailgun_reply_to_email" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_reply_to_email')); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Leave empty to use From Email', 'mailmoo-for-mailgun'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Reply-To Name', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="text" name="mailmoo_for_mailgun_reply_to_name" value="<?php echo esc_attr(get_option('mailmoo_for_mailgun_reply_to_name')); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Leave empty to use From Name', 'mailmoo-for-mailgun'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Enable Email Logging', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <select name="mailmoo_for_mailgun_enable_logging">
                        <option value="true" <?php selected(get_option('mailmoo_for_mailgun_enable_logging'), 'true'); ?>><?php esc_html_e('Yes', 'mailmoo-for-mailgun'); ?></option>
                        <option value="false" <?php selected(get_option('mailmoo_for_mailgun_enable_logging'), 'false'); ?>><?php esc_html_e('No', 'mailmoo-for-mailgun'); ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Log all sent emails for debugging and monitoring', 'mailmoo-for-mailgun'); ?></p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(__('Save Settings', 'mailmoo-for-mailgun')); ?>
    </form>
    
    <hr />
    
    <h2><?php esc_html_e('Mailgun API Status', 'mailmoo-for-mailgun'); ?></h2>
    <table class="form-table">
        <tr>
            <th scope="row"><?php esc_html_e('SDK Status', 'mailmoo-for-mailgun'); ?></th>
            <td>
                <?php if (class_exists('Mailgun\Mailgun')): ?>
                    <span style="color: green;">✓ <?php esc_html_e('Mailgun SDK is installed', 'mailmoo-for-mailgun'); ?></span>
                <?php else: ?>
                    <span style="color: red;">✗ <?php esc_html_e('Mailgun SDK is not installed', 'mailmoo-for-mailgun'); ?></span>
                <?php endif; ?>
            </td>
        </tr>
        
        <tr>
            <th scope="row"><?php esc_html_e('API Key', 'mailmoo-for-mailgun'); ?></th>
            <td>
                <?php if (!empty(get_option('mailmoo_for_mailgun_api_key'))): ?>
                    <span style="color: green;">✓ <?php esc_html_e('API Key is configured', 'mailmoo-for-mailgun'); ?></span>
                <?php else: ?>
                    <span style="color: orange;">⚠ <?php esc_html_e('API Key is not configured', 'mailmoo-for-mailgun'); ?></span>
                <?php endif; ?>
            </td>
        </tr>
        
        <tr>
            <th scope="row"><?php esc_html_e('Domain', 'mailmoo-for-mailgun'); ?></th>
            <td>
                <?php if (!empty(get_option('mailmoo_for_mailgun_domain'))): ?>
                    <span style="color: green;">✓ <?php echo esc_html(get_option('mailmoo_for_mailgun_domain')); ?></span>
                <?php else: ?>
                    <span style="color: orange;">⚠ <?php esc_html_e('Domain is not configured', 'mailmoo-for-mailgun'); ?></span>
                <?php endif; ?>
            </td>
        </tr>
        
        <tr>
            <th scope="row"><?php esc_html_e('From Email', 'mailmoo-for-mailgun'); ?></th>
            <td>
                <?php if (!empty(get_option('mailmoo_for_mailgun_from_email'))): ?>
                    <span style="color: green;">✓ <?php echo esc_html(get_option('mailmoo_for_mailgun_from_email')); ?></span>
                <?php else: ?>
                    <span style="color: orange;">⚠ <?php esc_html_e('From Email is not configured', 'mailmoo-for-mailgun'); ?></span>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    
    <hr />
    
    <h2><?php esc_html_e('Test Email', 'mailmoo-for-mailgun'); ?></h2>
    <form method="post" action="">
        <?php wp_nonce_field('mailmoo_for_mailgun_test_nonce'); ?>
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e('Send Test Email To', 'mailmoo-for-mailgun'); ?></th>
                <td>
                    <input type="email" name="test_email" value="<?php echo esc_attr(get_option('admin_email')); ?>" class="regular-text" required />
                    <p class="description"><?php esc_html_e('Enter email address to send test email', 'mailmoo-for-mailgun'); ?></p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(__('Send Test Email', 'mailmoo-for-mailgun'), 'secondary', 'send_test'); ?>
    </form>
    
</div>