jQuery(document).ready(function($) {
    // Handle view log click
    $('.view-log').on('click', function(e) {
        e.preventDefault();
        
        var logId = $(this).data('log-id');
        
        // AJAX request to get log details
        $.ajax({
            url: mailmoo_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'mailmoo_for_mailgun_get_log_details',
                log_id: logId,
                nonce: mailmoo_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#log-details').html(response.data);
                    $('#log-modal').show();
                } else {
                    alert('Error loading log details');
                }
            }
        });
    });
    
    // Close modal
    $('.mailmoo-for-mailgun-close').on('click', function() {
        $('#log-modal').hide();
    });
    
    // Close modal when clicking outside
    $(window).on('click', function(e) {
        if (e.target.id === 'log-modal') {
            $('#log-modal').hide();
        }
    });
});