<?php
declare(strict_types=1);

/**
 * Uninstall script
 *
 * @package Resend\WordPress
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Check if user has permission
if (!current_user_can('activate_plugins')) {
    return;
}

// Clear scheduled cron event
$resend_timestamp = wp_next_scheduled('resend_cleanup_old_logs');
if ($resend_timestamp) {
    wp_unschedule_event($resend_timestamp, 'resend_cleanup_old_logs');
}

// Delete options
delete_option('resend_api_key');
delete_option('resend_api_key_encrypted');
delete_option('resend_from_email');
delete_option('resend_from_name');
delete_option('resend_log_retention_days');

// Drop database table
global $wpdb;
$resend_table_name = $wpdb->prefix . 'resend_email_log';
// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,PluginCheck.Security.DirectDB.UnescapedDBParameter -- Table name cannot be prepared, but it's safe (from $wpdb->prefix). Uninstall script requires direct query and schema change.
$wpdb->query("DROP TABLE IF EXISTS {$resend_table_name}");

