<?php

/**
 * Plugin Name: Mail via Resend
 * Plugin URI: https://wordpress.org/plugins/mail-via-resend/
 * Description: Send WordPress emails via Resend. Includes email logging and management.
 * Version: 1.0.1
 * Author: Webscape
 * Author URI: https://webscape.co.nz
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: mail-via-resend
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

declare(strict_types=1);

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('RESEND_WP_VERSION', '1.0.1');
define('RESEND_WP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('RESEND_WP_PLUGIN_URL', plugin_dir_url(__FILE__));
define('RESEND_WP_PLUGIN_FILE', __FILE__);

// Autoloader
require_once RESEND_WP_PLUGIN_DIR . 'includes/autoload.php';

// Initialize plugin
Resend\WordPress\Plugin::get_instance()->init();

// Activation hook
register_activation_hook(__FILE__, [Resend\WordPress\Plugin::class, 'activate']);
