<?php
/**
 * Autoloader for Resend WordPress Plugin
 *
 * @package Resend\WordPress
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

spl_autoload_register(function ($class) {
    // Only handle classes in our namespace
    $prefix = 'Resend\\WordPress\\';
    $base_dir = RESEND_WP_PLUGIN_DIR . 'includes/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

