<?php
declare(strict_types=1);

/**
 * Service Container
 *
 * @package Resend\WordPress
 */

namespace Resend\WordPress;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Simple service container for dependency injection
 */
class ServiceContainer {
    /**
     * Services cache
     *
     * @var array<string, object>
     */
    private array $services = [];

    /**
     * Get a service instance
     *
     * @param string $class Service class name
     * @return object
     */
    public function get(string $class): object {
        if (!isset($this->services[$class])) {
            $this->services[$class] = new $class($this);
        }

        return $this->services[$class];
    }
}

