<?php
declare(strict_types=1);

/**
 * Database Management
 *
 * @package Resend\WordPress
 */

namespace Resend\WordPress;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Database operations
 */
class Database {
    /**
     * Create database tables
     *
     * @return void
     */
    public static function create_tables(): void {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . 'resend_email_log';

        $sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
            id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            to_email varchar(255) NOT NULL,
            subject varchar(500) NOT NULL,
            headers text DEFAULT NULL,
            body_excerpt text DEFAULT NULL,
            status varchar(50) NOT NULL,
            response_id varchar(255) DEFAULT NULL,
            error_message text DEFAULT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY status (status),
            KEY created_at (created_at),
            KEY to_email (to_email(191))
        ) {$charset_collate};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }

    /**
     * Drop database tables
     *
     * @return void
     */
    public static function drop_tables(): void {
        global $wpdb;

        $resend_table_name = $wpdb->prefix . 'resend_email_log';
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,PluginCheck.Security.DirectDB.UnescapedDBParameter -- Table name cannot be prepared, but it's safe (from $wpdb->prefix). Schema change requires direct query.
        $wpdb->query("DROP TABLE IF EXISTS {$resend_table_name}");
    }
}

