/**
 * Resend Admin JavaScript
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        $('#resend-send-test-email').on('click', function(e) {
            e.preventDefault();

            const $button = $(this);
            const $result = $('#resend-test-email-result');
            const testEmail = $('#test_email').val();

            // Validate email
            if (!testEmail || !testEmail.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
                $result
                    .removeClass('notice-success')
                    .addClass('notice notice-error')
                    .html('<p><strong>' + resendAdmin.strings.error + '</strong> ' + 'Please enter a valid email address.' + '</p>')
                    .show();
                return;
            }

            // Disable button and show loading state
            $button.prop('disabled', true).text(resendAdmin.strings.sending);

            // Clear previous result
            $result.hide().removeClass('notice-success notice-error');

            // Send AJAX request
            $.ajax({
                url: resendAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'resend_send_test_email',
                    nonce: resendAdmin.nonce,
                    test_email: testEmail
                },
                success: function(response) {
                    if (response.success) {
                        $result
                            .removeClass('notice-error')
                            .addClass('notice notice-success is-dismissible')
                            .html('<p><strong>' + resendAdmin.strings.success + '</strong></p>')
                            .show();
                    } else {
                        $result
                            .removeClass('notice-success')
                            .addClass('notice notice-error is-dismissible')
                            .html('<p><strong>' + resendAdmin.strings.error + '</strong> ' + (response.data && response.data.message ? response.data.message : 'Unknown error') + '</p>')
                            .show();
                    }
                },
                error: function(xhr, status, error) {
                    $result
                        .removeClass('notice-success')
                        .addClass('notice notice-error is-dismissible')
                        .html('<p><strong>' + resendAdmin.strings.error + '</strong> ' + error + '</p>')
                        .show();
                },
                complete: function() {
                    // Re-enable button
                    $button.prop('disabled', false).text(resendAdmin.strings.buttonText);
                }
            });
        });

        // Handle dismissible notices
        $(document).on('click', '.notice[data-notice] .notice-dismiss', function() {
            const $notice = $(this).closest('.notice');
            const noticeName = $notice.data('notice');

            if (noticeName && resendAdmin.dismissNonce) {
                $.ajax({
                    url: resendAdmin.ajaxUrl,
                    type: 'POST',
                    data: {
                        action: 'resend_dismiss_notice',
                        nonce: resendAdmin.dismissNonce,
                        notice: noticeName
                    }
                });
            }
        });

        // Track if a resend request is in progress to prevent duplicates
        let resendInProgress = false;

        // Handle resend email button (using event delegation for reliability)
        $(document).on('click', '#resend-resend-email', function(e) {
            e.preventDefault();

            // Prevent multiple simultaneous requests
            if (resendInProgress) {
                return;
            }

            // Check if resendAdmin is available
            if (typeof resendAdmin === 'undefined' || !resendAdmin.resendNonce) {
                console.error('Resend admin data not available');
                alert('Error: Resend configuration not loaded. Please refresh the page.');
                return;
            }

            const $button = $(this);
            
            // Check if button is already disabled (another request in progress)
            if ($button.prop('disabled')) {
                return;
            }

            const $result = $('#resend-resend-result');
            const logId = $button.data('log-id');

            if (!logId) {
                console.error('Log ID not found');
                return;
            }

            // Show confirmation dialog
            const confirmMessage = resendAdmin.strings && resendAdmin.strings.resendConfirm 
                ? resendAdmin.strings.resendConfirm 
                : 'Are you sure you want to resend this email?';
            
            if (!confirm(confirmMessage)) {
                return;
            }

            // Set flag to prevent duplicate requests
            resendInProgress = true;

            // Disable button and show loading state
            const resendingText = resendAdmin.strings && resendAdmin.strings.resending 
                ? resendAdmin.strings.resending 
                : 'Resending...';
            $button.prop('disabled', true).text(resendingText);

            // Clear previous result
            $result.hide().removeClass('notice-success notice-error');

            // Send AJAX request
            $.ajax({
                url: resendAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'resend_resend_email',
                    nonce: resendAdmin.resendNonce,
                    log_id: logId
                },
                success: function(response) {
                    const successText = resendAdmin.strings && resendAdmin.strings.resendSuccess 
                        ? resendAdmin.strings.resendSuccess 
                        : 'Email resent successfully!';
                    const errorText = resendAdmin.strings && resendAdmin.strings.resendError 
                        ? resendAdmin.strings.resendError 
                        : 'Failed to resend email: ';

                    if (response.success) {
                        $result
                            .removeClass('notice-error')
                            .addClass('notice notice-success')
                            .html('<strong>' + successText + '</strong>')
                            .show();
                    } else {
                        $result
                            .removeClass('notice-success')
                            .addClass('notice notice-error')
                            .html('<strong>' + errorText + '</strong> ' + (response.data && response.data.message ? response.data.message : 'Unknown error'))
                            .show();
                    }
                },
                error: function(xhr, status, error) {
                    const errorText = resendAdmin.strings && resendAdmin.strings.resendError 
                        ? resendAdmin.strings.resendError 
                        : 'Failed to resend email: ';
                    $result
                        .removeClass('notice-success')
                        .addClass('notice notice-error')
                        .html('<strong>' + errorText + '</strong> ' + error)
                        .show();
                },
                complete: function() {
                    // Reset flag and re-enable button
                    resendInProgress = false;
                    const buttonText = resendAdmin.strings && resendAdmin.strings.resendButtonText 
                        ? resendAdmin.strings.resendButtonText 
                        : 'Resend Email';
                    $button.prop('disabled', false).text(buttonText);
                }
            });
        });
    });
})(jQuery);

