# Mail via Resend

A WordPress plugin that routes all `wp_mail()` calls through [Resend](https://resend.com), providing reliable email delivery with comprehensive logging and management features.

> **Note:** This plugin is not officially associated with or endorsed by Resend. It is an independent, community-developed plugin that integrates with Resend's API service.

## Features

- **Resend Integration**: All WordPress emails are automatically sent via Resend API
- **Email Logging**: Complete email log with searchable, paginated interface
- **Settings Management**: Easy configuration of API key and default email settings
- **Automatic Cleanup**: Configurable log retention with automatic cleanup via WP-Cron
- **Developer Friendly**: Hooks and filters for extensibility

## Installation

1. Upload the plugin files to `/wp-content/plugins/mail-via-resend/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to **Settings → Resend** in the WordPress admin menu and configure your API key

## Configuration

### Getting Your API Key

1. Sign up for a Resend account at [https://resend.com](https://resend.com)
2. Navigate to API Keys in your dashboard
3. Create a new API key
4. Copy the API key and paste it into the plugin settings

### Settings

- **API Key**: Your Resend API key (required)
- **From Email**: Default email address to send from (must be verified in Resend)
- **From Name**: Default name to send emails from
- **Log Retention**: Number of days to keep email logs (default: 30)

## Usage

Once configured, all WordPress emails sent via `wp_mail()` will automatically be routed through Resend. No code changes are required.

### Helper Function

The plugin provides a helper function for convenience:

```php
resend_wp($to, $subject, $message, $headers, $attachments);
```

This is essentially a wrapper around `wp_mail()`.

### Hooks and Filters

#### Filters

- `resend_before_send`: Modify the payload before sending to Resend API
  ```php
  add_filter('resend_before_send', function($payload, $to_addresses, $subject, $body) {
      // Modify $payload array
      return $payload;
  }, 10, 4);
  ```

#### Actions

- `resend_after_send`: Fired after successful email send
  ```php
  add_action('resend_after_send', function($response_data, $payload, $to_addresses, $subject, $body) {
      // Handle successful send
  }, 10, 5);
  ```

## Email Log

The plugin maintains a complete log of all emails sent through Resend. Access it via **Tools → Email Log** in the WordPress admin menu.

### Features

- **Search**: Search by recipient email or subject
- **Filter**: Filter by status (sent/failed)
- **Pagination**: Navigate through logs with pagination
- **Details**: View complete email details including headers and body excerpt
- **Bulk Delete**: Delete multiple log entries at once

### Log Fields

- To email address
- Subject
- Status (sent/failed)
- Resend response ID
- Timestamp
- Error message (if failed)
- Headers
- Body excerpt (first 500 characters)

## Requirements

- WordPress 5.8 or higher
- PHP 7.4 or higher
- Resend API key

## Database

The plugin creates a custom table `wp_resend_email_log` to store email logs. This table is automatically created on plugin activation and removed on uninstall.

## Uninstall

On plugin uninstall, all settings and the email log table are removed. To preserve data, deactivate instead of uninstalling.

## Support

For issues, feature requests, or contributions, please visit the [GitHub repository](https://github.com/resend/resend-wordpress).

## Privacy Policy

This plugin collects and stores the following data:

- Email addresses of recipients (stored locally in your database)
- Email subjects and body excerpts (first 500 characters, stored locally)
- Email headers (stored locally)
- Email delivery status and Resend API response IDs (stored locally)

All data is stored locally in your WordPress database and is not transmitted to any third-party service except Resend for the purpose of sending emails. Email logs are stored in a custom database table and can be managed or deleted through the plugin's admin interface.

By using this plugin, you consent to sending emails through the Resend service. Please review [Resend's Privacy Policy](https://resend.com/legal/privacy-policy) and [Terms of Service](https://resend.com/legal/terms-of-service) for information about how Resend handles your data.

## Changelog

### 1.0.1

- Confirmed compatibility with WordPress 6.9.
- Preserve PHPMailer-derived From/Sender headers when routing mail through Resend to align with wp_mail() behavior in WordPress 6.9.

### 1.0.0

- Initial release
- Resend API integration
- Email logging functionality
- Admin settings page
- Email log management interface

## Credits

Plugin built by [Webscape](https://webscape.co.nz). Need help with WordPress? [Contact us](https://webscape.co.nz/contact).

## License

GPLv2 or later
