<?php
/**
 * Activator Class
 *
 * @package MailForwarderToTelegram
 */

if (!defined('ABSPATH')) {
	exit;
}

/**
 * Activator
 * Handles plugin activation
 */
class MailForwarderToTelegram_Activator
{

	/**
	 * Activate plugin
	 */
	public static function activate()
	{
		self::create_database_table();
	}

	/**
	 * Create database table for logs
	 */
	private static function create_database_table()
	{
		global $wpdb;

		$table_name = $wpdb->prefix . 'mail_forwarder_to_telegram_logs';
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            date datetime NOT NULL,
            subject text NOT NULL,
            to_recipients text NOT NULL,
            message longtext NOT NULL,
            attachments longtext,
            email_sent tinyint(1) NOT NULL DEFAULT 0,
            sent_to_telegram tinyint(1) NOT NULL DEFAULT 0,
            PRIMARY KEY  (id),
            KEY date (date),
            KEY email_sent (email_sent),
            KEY sent_to_telegram (sent_to_telegram)
        ) {$charset_collate};";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);

		// Store database version
		update_option('mail_forwarder_to_telegram_db_version', '1.0.0');
	}
}
