jQuery(document).ready(function($){
	// Select all checkboxes
	$('#cb-select-all').on('click', function(){
		$('input[name="log_ids[]"]').prop('checked', $(this).prop('checked'));
	});

	// View log details
	$('.view-log-details').on('click', function(){
		var logId = $(this).data('log-id');
		$('#log-details-' + logId).toggle();
	});

	// Resend Email
	$('.resend-email').on('click', function(){
		var button = $(this);
		var logId = button.data('log-id');

		if(!confirm(mail_forwarder_to_telegramLogs.confirmResendEmail)){
			return;
		}

		button.prop('disabled', true).text(mail_forwarder_to_telegramLogs.sendingText);

		$.ajax({
			url: mail_forwarder_to_telegramLogs.ajaxUrl,
			type: 'POST',
			data: {
				action: 'mail_forwarder_to_telegram_resend_email',
				log_id: logId,
				nonce: mail_forwarder_to_telegramLogs.nonce
			},
			success: function(response){
				if(response.success){
					alert(response.data.message);
					location.reload();
				}
				else {
					alert(mail_forwarder_to_telegramLogs.errorText + ' ' + response.data.message);
				}
			},
			error: function(){
				alert(mail_forwarder_to_telegramLogs.ajaxErrorText);
			},
			complete: function(){
				button.prop('disabled', false).html('<span class="dashicons dashicons-email-alt" style="font-size: 14px; line-height: 20px;"></span>');
			}
		});
	});

	// Resend to Telegram
	$('.resend-telegram').on('click', function(){
		var button = $(this);
		var logId = button.data('log-id');

		if(!confirm(mail_forwarder_to_telegramLogs.confirmResendTelegram)){
			return;
		}

		button.prop('disabled', true).text(mail_forwarder_to_telegramLogs.sendingText);

		$.ajax({
			url: mail_forwarder_to_telegramLogs.ajaxUrl,
			type: 'POST',
			data: {
				action: 'mail_forwarder_to_telegram_resend_telegram',
				log_id: logId,
				nonce: mail_forwarder_to_telegramLogs.nonce
			},
			success: function(response){
				if(response.success){
					alert(response.data.message);
					location.reload();
				}
				else {
					alert(mail_forwarder_to_telegramLogs.errorText + ' ' + response.data.message);
				}
			},
			error: function(){
				alert(mail_forwarder_to_telegramLogs.ajaxErrorText);
			},
			complete: function(){
				button.prop('disabled', false).html('<span class="dashicons dashicons-share" style="font-size: 14px; line-height: 20px;"></span>');
			}
		});
	});
});
