document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.mpvw-thumbnail').forEach(function (thumbnail) {
        thumbnail.addEventListener('click', function () {
            // Get values of data attributes
            const videoWebm = this.getAttribute('data-webm');
            const videoMp4 = this.getAttribute('data-mp4');

            // Check if a video player already exists
            const existingPlayer = document.querySelector('.mpvw-video-container');
            if (existingPlayer) {
                existingPlayer.remove(); // Remove the old player
            }

            // Create a container for the video
            const videoContainer = document.createElement('div');
            videoContainer.className = 'mpvw-video-container';

            // Create the video player
            const videoHtml = document.createElement('video');
            videoHtml.className = 'mpvw-video video-js';
            videoHtml.autoplay = true;
            videoHtml.muted = true;
            videoHtml.loop = true;

            // Add video sources
            if (videoWebm) {
                const sourceWebm = document.createElement('source');
                sourceWebm.src = videoWebm;
                sourceWebm.type = 'video/webm';
                videoHtml.appendChild(sourceWebm);
            }
            if (videoMp4) {
                const sourceMp4 = document.createElement('source');
                sourceMp4.src = videoMp4;
                sourceMp4.type = 'video/mp4';
                videoHtml.appendChild(sourceMp4);
            }

            // Append the video player to the container
            videoContainer.appendChild(videoHtml);

            // Add a button to close the video
            const closeButton = document.createElement('button');
            closeButton.className = 'mpvw-video-container__button';
            closeButton.addEventListener('click', function () {
                videoContainer.remove(); // Remove the video container
            });

            videoContainer.appendChild(closeButton);

            // Append the video container to the end of the document
            document.body.appendChild(videoContainer);

            initPlayer();
        });
    });
});


jQuery(window).on('load', function () {
    if (typeof jQuery.fn.flexslider === 'function') {
        const slider = jQuery('.woocommerce-product-gallery').flexslider({
            start: function (slider) {
                initPlayer();
            }
        });
    }
});

function initPlayer() {
    const playerDefaultOptions = {
        controls: false,
        muted: true,
        autoplay: 'muted',
        playsinline: true,
        loop: true,
        fluid: false
    };
    const keyWithStringValue = ['autoplay', 'defaultVolume', 'aspectRatio', 'objectFit'];
    const videoElements = document.querySelectorAll('.video-js');
    videoElements.forEach(videoElement => {
        let playerOptions = {...playerDefaultOptions};
        let volume = 0;
        let objectFit = 'contain';
        if (typeof playerOptionsMPVW !== 'undefined' && playerOptionsMPVW !== null) {
            Object.keys(playerOptionsMPVW).forEach(key => {
                if (playerOptionsMPVW[key] === null) return;
                if (!keyWithStringValue.includes(key)) {
                    playerOptions[key] = !!playerOptionsMPVW[key];
                    return;
                }
                if (key === 'defaultVolume') {
                    volume = parseInt(playerOptionsMPVW[key]) / 100;
                    return;
                }
                if (key === 'objectFit') {
                    objectFit = playerOptionsMPVW[key];
                    return;
                }
                playerOptions[key] = playerOptionsMPVW[key];
            });
        }
        const player = videojs(videoElement, playerOptions);
        player.ready(function () {
            let tech = this.el().querySelector('.vjs-tech');
            if (tech) tech.style.objectFit = objectFit;
            if (!playerOptions['muted']) this.volume(volume);
        });
    });
}
